% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_infections.R
\name{estimate_infections}
\alias{estimate_infections}
\title{Estimate Infections, the Time-Varying Reproduction Number and the Rate of
Growth}
\usage{
estimate_infections(
  data,
  generation_time = gt_opts(),
  delays = delay_opts(),
  truncation = trunc_opts(),
  rt = rt_opts(),
  backcalc = backcalc_opts(),
  gp = gp_opts(),
  obs = obs_opts(),
  forecast = forecast_opts(),
  stan = stan_opts(),
  CrIs = c(0.2, 0.5, 0.9),
  weigh_delay_priors = TRUE,
  id = "estimate_infections",
  verbose = interactive(),
  filter_leading_zeros = TRUE,
  zero_threshold = Inf,
  horizon
)
}
\arguments{
\item{data}{A \verb{<data.frame>} of disease reports (confirm) by date (date).
\code{confirm} must be numeric and \code{date} must be in date format. Optionally
this can also have a logical \code{accumulate} column which indicates whether
data should be added to the next data point. This is useful when modelling
e.g. weekly incidence data. See also the \code{\link[=fill_missing]{fill_missing()}} function which
helps add the \code{accumulate} column with the desired properties when dealing
with non-daily data. If any accumulation is done this happens after
truncation as specified by the \code{truncation} argument.}

\item{generation_time}{A call to \code{\link[=gt_opts]{gt_opts()}} (or its alias
\code{\link[=generation_time_opts]{generation_time_opts()}}) defining the generation time distribution used.
For backwards compatibility a list of summary parameters can also be passed.}

\item{delays}{A call to \code{\link[=delay_opts]{delay_opts()}} defining delay distributions and
options. See the documentation of \code{\link[=delay_opts]{delay_opts()}} and the examples below for
details.}

\item{truncation}{A call to \code{\link[=trunc_opts]{trunc_opts()}} defining the truncation of
the observed data. Defaults to \code{\link[=trunc_opts]{trunc_opts()}}, i.e. no truncation.  See the
\code{\link[=estimate_truncation]{estimate_truncation()}} help file for an approach to estimating this from
data where the \code{dist} list element returned by \code{\link[=estimate_truncation]{estimate_truncation()}} is
used as the \code{truncation} argument here, thereby propagating the uncertainty
in the estimate.}

\item{rt}{A list of options as generated by \code{\link[=rt_opts]{rt_opts()}} defining Rt
estimation. Defaults to \code{\link[=rt_opts]{rt_opts()}}. To generate new infections using
the non-mechanistic model instead of the renewal equation model, use
\code{rt = NULL}. The non-mechanistic model internally uses the setting
\code{rt = rt_opts(use_rt = FALSE, future = "project", gp_on = "R0")}.}

\item{backcalc}{A list of options as generated by \code{\link[=backcalc_opts]{backcalc_opts()}} to
define the back calculation. Defaults to \code{\link[=backcalc_opts]{backcalc_opts()}}.}

\item{gp}{A list of options as generated by \code{\link[=gp_opts]{gp_opts()}} to define the
Gaussian process. Defaults to \code{\link[=gp_opts]{gp_opts()}}. Set to \code{NULL} to disable the
Gaussian process.}

\item{obs}{A list of options as generated by \code{\link[=obs_opts]{obs_opts()}} defining the
observation model. Defaults to \code{\link[=obs_opts]{obs_opts()}}.}

\item{forecast}{A list of options as generated by \code{\link[=forecast_opts]{forecast_opts()}} defining
the forecast opitions. Defaults to \code{\link[=forecast_opts]{forecast_opts()}}. If NULL then no
forecasting will be done.}

\item{stan}{A list of stan options as generated by \code{\link[=stan_opts]{stan_opts()}}. Defaults
to \code{\link[=stan_opts]{stan_opts()}}. Can be used to override \code{data}, \code{init}, and \code{verbose}
settings if desired.}

\item{CrIs}{Numeric vector of credible intervals to calculate.}

\item{weigh_delay_priors}{Logical. If TRUE (default), all delay distribution
priors will be weighted by the number of observation data points, in doing so
approximately placing an independent prior at each time step and usually
preventing the posteriors from shifting. If FALSE, no weight will be applied,
i.e. delay distributions will be treated as a single parameters.}

\item{id}{A character string used to assign logging information on error.
Used by \code{\link[=regional_epinow]{regional_epinow()}} to assign errors to regions. Alter the default to
run with error catching.}

\item{verbose}{Logical, defaults to \code{TRUE} when used interactively and
otherwise \code{FALSE}. Should verbose debug progress messages be printed.
Corresponds to the "DEBUG" level from \code{futile.logger}. See \code{setup_logging}
for more detailed logging options.}

\item{filter_leading_zeros}{Logical, defaults to TRUE. Should zeros at the
start of the time series be filtered out.}

\item{zero_threshold}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Numeric defaults
to Inf. Indicates if detected zero cases are meaningful by using a threshold
number of cases based on the 7-day average. If the average is above this
threshold then the zero is replaced using \code{fill}.}

\item{horizon}{Deprecated; use \code{forecast} instead to specify the predictive
horizon}
}
\value{
A list of output including: posterior samples, summarised posterior
samples, data used to fit the model, and the fit object itself.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}
Uses a non-parametric approach to reconstruct cases by date of infection
from reported cases. It uses either a generative Rt model or non-parametric
back calculation to estimate underlying latent infections and then maps
these infections to observed cases via uncertain reporting delays and a
flexible observation model. See the examples and function arguments for the
details of all options. The default settings may not be sufficient for your
use case so the number of warmup samples (\code{stan_args = list(warmup)}) may
need to be increased as may the overall number of samples. Follow the links
provided by any warnings messages to diagnose issues with the MCMC fit. It
is recommended to explore several of the Rt estimation approaches supported
as not all of them may be suited to users own use cases. See
\href{https://gist.github.com/seabbs/163d0f195892cde685c70473e1f5e867}{here}
for an example of using \code{estimate_infections} within the \code{epinow} wrapper to
estimate Rt for Covid-19 in a country from the ECDC data source.
}
\examples{
\donttest{
# set number of cores to use
old_opts <- options()
options(mc.cores = ifelse(interactive(), 4, 1))

# get example case counts
reported_cases <- example_confirmed[1:60]

# set an example generation time. In practice this should use an estimate
# from the literature or be estimated from data
generation_time <- Gamma(
  shape = Normal(1.3, 0.3),
  rate = Normal(0.37, 0.09),
  max = 14
)
# set an example incubation period. In practice this should use an estimate
# from the literature or be estimated from data
incubation_period <- LogNormal(
  meanlog = Normal(1.6, 0.06),
  sdlog = Normal(0.4, 0.07),
  max = 14
)
# set an example reporting delay. In practice this should use an estimate
# from the literature or be estimated from data
reporting_delay <- LogNormal(mean = 2, sd = 1, max = 10)

# for more examples, see the "estimate_infections examples" vignette
def <- estimate_infections(reported_cases,
  generation_time = gt_opts(generation_time),
  delays = delay_opts(incubation_period + reporting_delay),
  rt = rt_opts(prior = LogNormal(mean = 2, sd = 0.1))
)
# real time estimates
summary(def)
# summary plot
plot(def)
options(old_opts)
}
}
\seealso{
\code{\link[=epinow]{epinow()}} \code{\link[=regional_epinow]{regional_epinow()}} \code{\link[=forecast_infections]{forecast_infections()}}
\code{\link[=estimate_truncation]{estimate_truncation()}}
}
