% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TTT_hazard_shape.R
\encoding{UTF-8}
\name{TTT_hazard_shape}
\alias{TTT_hazard_shape}
\alias{TTT_hazard_shape.formula}
\alias{TTT_hazard_shape.EmpiricalTTT}
\title{Hazard Shape estimation from TTT plot}
\usage{
TTT_hazard_shape(object, ...)

\method{TTT_hazard_shape}{formula}(
  formula,
  data = NULL,
  local_reg = loess.options(),
  interpolation = interp.options(),
  silent = FALSE,
  ...
)

\method{TTT_hazard_shape}{EmpiricalTTT}(
  object,
  local_reg = loess.options(),
  interpolation = interp.options(),
  silent = FALSE,
  ...
)
}
\arguments{
\item{object}{An alternative way for getting the hazard shape
estimation in passing directly the \code{EmpiricalTTT} object
generated with \code{\link{TTTE_Analytical}}.}

\item{...}{further arguments passed to
\code{\link{TTTE_Analytical}}.}

\item{formula}{An object of class \code{\link[stats]{formula}} with the response on
the left of an operator \code{~}. The right side must be
\code{1}.}

\item{data}{an optional data frame containing the response variables. If
data is not specified, the variables are taken from the
environment from which \code{\link{TTT_hazard_shape}} is called.}

\item{local_reg}{a list of control parameters for LOESS. See
\code{\link{loess.options}}.}

\item{interpolation}{a list of control parameters for interpolation function. See
\code{\link{interp.options}}.}

\item{silent}{logical. If TRUE, warnings of \code{TTT_hazard_shape} are suppressed.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function can be used so as to estimate hazard shape corresponding
to a given data set. This is a wrapper for
\code{\link[EstimationTools]{TTTE_Analytical}}.
}
\details{
This function performs a non-parametric estimation of the empirical total
time on test (TTT) plot. Then, this estimated curve can be used so as to
get suggestions about initial values and the search region for parameters
based on hazard shape associated to the  shape of empirical TTT plot.

Use \code{\link{Hazard_Shape}} function to get the results for shape estimation.
}
\examples{
#--------------------------------------------------------------------------------
# Example 1: Increasing hazard and its corresponding TTT statistic with
#            simulated data

hweibull <- function(x, shape, scale){
  dweibull(x, shape, scale)/pweibull(x, shape, scale, lower.tail = FALSE)
  }
curve(hweibull(x, shape = 2.5, scale = pi), from = 0, to = 42,
               col = "red", ylab = "Hazard function", las = 1, lwd = 2)

y <- rweibull(n = 50, shape = 2.5, scale = pi)
status <- c(rep(1, 48), rep(0, 2))
my_initial_guess1 <- TTT_hazard_shape(Surv(y, status) ~ 1)
my_initial_guess1$hazard_type


#--------------------------------------------------------------------------------
# Example 2: Same example using an 'EmpiricalTTT' object

y <- rweibull(n = 50, shape = 2.5, scale = pi)
TTT_wei <- TTTE_Analytical(y ~ 1)
my_initial_guess2 <- TTT_hazard_shape(TTT_wei)
my_initial_guess2$hazard_type


#--------------------------------------------------------------------------------
# Example 3: Increasing hazard with simulated censored data

hweibull <- function(x, shape, scale){
  dweibull(x, shape, scale)/pweibull(x, shape, scale, lower.tail = FALSE)
  }
curve(hweibull(x, shape = 2.5, scale = pi), from = 0, to = 42,
               col = "red", ylab = "Hazard function", las = 1, lwd = 2)

y <- rweibull(n = 50, shape = 2.5, scale = pi)
y <- sort(y)
status <- c(rep(1, 45), rep(0, 5))
my_initial_guess1 <- TTT_hazard_shape(Surv(y, status) ~ 1)
my_initial_guess1$hazard_type


#--------------------------------------------------------------------------------
}
\seealso{
\code{\link{print.HazardShape}}, \code{\link{plot.HazardShape}},
\code{\link{TTTE_Analytical}}
}
\author{
Jaime Mosquera Gutiérrez \email{jmosquerag@unal.edu.co}
}
\concept{HazardShape}
