% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Chen_2016_event_time.R
\name{Chen_2016_event_time}
\alias{Chen_2016_event_time}
\title{Function to generate event time in the existence of cured population}
\usage{
Chen_2016_event_time(u, hr, distribution, p, lag, a, b, mu, sd)
}
\arguments{
\item{u}{a scalar with between 0 and 1}

\item{hr}{hazard ratio if this subject in the corresponding arm vs control arm}

\item{distribution}{the distribution for the control arm, valid values of inputs include: exponential, weibull, log-normal, log-logistic}

\item{p}{the proportion of cured population in the control arm}

\item{lag}{delayed treatment effect time after treatment initialization, when the hr between treatment arm and control =1 until lag time}

\item{a}{the shape parameter in the Weibull or the log-logistic distribution}

\item{b}{the scale parameter in the exponential, Weibull or the log-logistic distribution}

\item{mu}{the mean in the log-normal distribution}

\item{sd}{the standard deviation in the log-normal distribution}
}
\value{
the event time
}
\description{
generate event time under the delay-treatment effect and cured population setting
}
\references{
\itemize{
\item Chen, Tai-Tsang. "Predicting analysis times in randomized clinical trials with cancer immunotherapy."
BMC medical research methodology 16.1 (2016): 1-10.
}
}
