% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Chen_2016_event_time_piecewise_exp_abovetime0.R
\name{Chen_2016_event_time_piecewise_exp_abovetime0}
\alias{Chen_2016_event_time_piecewise_exp_abovetime0}
\title{Function to generate event time with piecewise exponential distribution for ongoing subject in the existence of cured population}
\usage{
Chen_2016_event_time_piecewise_exp_abovetime0(
  u,
  p,
  time0 = 0,
  piecewiseSurvivalTime = 0,
  piecewisehazard
)
}
\arguments{
\item{u}{a scalar with between 0 and 1, which is the conditional survival probability at the event time.}

\item{p}{the proportion of cured population in the control arm}

\item{time0}{the observed ongoing survival time}

\item{piecewiseSurvivalTime}{A vector that specifies the time
intervals for the piecewise exponential survival distribution.
Must start with 0, e.g., c(0, 60) breaks the time axis into 2
event intervals: [0, 60) and [60, Inf). By default, it is set to 0.}

\item{piecewisehazard}{A vector that specifies the hazard rate in
intervals for the piecewise exponential survival distribution.}
}
\value{
the event time
}
\description{
generate event time under the delay-treatment effect and cured population setting
}
\references{
\itemize{
\item Chen, Tai-Tsang. "Predicting analysis times in randomized clinical trials with cancer immunotherapy."
BMC medical research methodology 16.1 (2016): 1-10.
}
}
