% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictEvent.R
\name{predictEvent}
\alias{predictEvent}
\title{Predict event time for ongoing subjects with or without cured population.}
\usage{
predictEvent(
  df = NULL,
  target_d,
  newSubjects = NULL,
  event_fit,
  dropout_fit = NULL,
  fixedFollowup = FALSE,
  followupTime = 365,
  pilevel = 0.9,
  nyears = 4,
  nreps = 500,
  showEnrollment = TRUE,
  showEvent = TRUE,
  showDropout = FALSE,
  showOngoing = FALSE,
  by_treatment = FALSE,
  seed.num = NULL
)
}
\arguments{
\item{df}{The subject-level enrollment and event data,
including \code{randdt}, \code{cutoffdt},
\code{time}, \code{event}, and \code{dropout}. By default, it
is set to \code{NULL} for event prediction at the design stage.}

\item{target_d}{The target number of events to reach in the study.}

\item{newSubjects}{The enrollment data for new subjects including
\code{draw} and \code{arrivalTime}. By default,
it is set to \code{NULL}, indicating the completion of
subject enrollment.}

\item{event_fit}{The pre-fitted event model used to generate
predictions.}

\item{dropout_fit}{The pre-fitted dropout model used to generate
predictions. By default, it is set to \code{NULL},
indicating no dropout.}

\item{fixedFollowup}{A Boolean variable indicating whether a fixed
follow-up design is used. By default, it is set to \code{FALSE}
for a variable follow-up design.}

\item{followupTime}{The follow-up time for a fixed
follow-up design, in days. By default, it is set to 365.}

\item{pilevel}{The prediction interval level. By default,
it is set to 0.90.}

\item{nyears}{The number of years after the data cut for prediction.
By default, it is set to 4.}

\item{nreps}{The number of replications for simulation. By default,
it is set to 500. If \code{newSubjects} is not \code{NULL},
the number of draws in \code{newSubjects} should be \code{nreps}.}

\item{showEnrollment}{A Boolean variable to control whether or not to
show the number of enrolled subjects. By default, it is set to
\code{TRUE}.}

\item{showEvent}{A Boolean variable to control whether or not to
show the number of events. By default, it is set to
\code{TRUE}.}

\item{showDropout}{A Boolean variable to control whether or not to
show the number of dropouts. By default, it is set to
\code{FALSE}.}

\item{showOngoing}{A Boolean variable to control whether or not to
show the number of ongoing subjects. By default, it is set to
\code{FALSE}.}

\item{by_treatment}{A Boolean variable to control whether or not to
predict event by treatment group. By default,
it is set to \code{FALSE}.}

\item{seed.num}{The number of the random seed. The default is NULL.}
}
\value{
A list of prediction results which includes important
information such as the median, lower and upper percentiles for
the estimated day and date to reach the target number of events,
as well as simulated event data for both ongoing and new subjects.
The data for the prediction plot is also included
within this list.
}
\description{
Utilizes pre-fitted time-to-event and time-to-dropout models
to generate event and dropout times for ongoing subjects
and new subjects. It also provides a
prediction interval for the expected time to reach the target
number of events.
}
\details{
To ensure successful event prediction at the design stage, it is
important to provide the \code{newSubjects} data set.

To specify the event model used during the design-stage event
prediction, the \code{event_fit} be a list with one element
per treatment. For each treatment, the element should include \code{w}
to specify the weight of the treatment in a randomization block,
\code{model} to specify the event model
(exponential, weibull, log-logistic, log-normal,
or piecewise exponential, weibull with cured population,exponential with cured population,log-normal with cured population,
log-logistic with cured population,piecewise exponential with cured population,
exponential with cured population and delayed treatment,weibull with cured population and delayed treatment,
log-normal with cured population and delayed treatment,log-logistic with cured population and delayed treatment),
\code{theta} and \code{vtheta} to indicate
the parameter values and the covariance matrix.
For the piecewise exponential or piecewise exponential with cured population or piecewise exponential with cured population
and delayed treatment event model, the list
should also include \code{piecewiseSurvivalTime} to indicate
the location of knots. It should be noted that the model averaging
and spline options are not appropriate for use as prior.

To specify the dropout model used during the design stage
event prediction, the \code{dropout_fit} should be a list
with one element per treatment. For each treatment, the element
should include \code{w} to specify the weight of the treatment
in a randomization block, \code{model} to specify the dropout model
(exponential, weibull, log-logistic, log-normal,
or piecewise exponential), \code{theta} and \code{vtheta} to indicate
the parameter values and the covariance matrix.
For the piecewise exponential dropout model, the list
should also include \code{piecewiseDropoutTime} to indicate
the location of knots.

Following the commencement of the trial, we obtain the event
model fit and the dropout model fit based on the observed data,
denoted as \code{event_fit} and \code{dropout_fit}, respectively.
These fitted models are subsequently utilized to generate event
and dropout times for both ongoing and new subjects in the trial.
}
\examples{
\donttest{
fit1 <- list(model = "piecewise uniform",
             theta = -0.58, 
             vtheta=0, accrualTime =0)
fit2<-list()
fit2[[1]] <- list(model = "weibull with cured population and delayed treatment", 
                  theta = c(-2.2,0,6.5,0,1), 
                  vtheta = matrix(0,5,5))
fit2[[2]] <- list(model = "weibull with cured population and delayed treatment", 
                 theta = c(-2.2,0,6.5,46,0.65), 
                 vtheta = matrix(0,5,5))
                  
 enroll_pred <- predictEnrollment(df = NULL, target_n=200, enroll_fit = fit1,lags=46,
                                  pilevel=0.9, nyears=4, nreps=100,by_treatment=TRUE,
                                  ngroups=2, alloc=c(1,1), treatment_label=c('a','b'))

 event_pred <- predictEvent(df = NULL, target_d=60,
                            newSubjects = enroll_pred$newSubjects,
                            event_fit = fit2,dropout_fit = NULL,
                            pilevel=0.9, 
                            nyears=4, 
                            nreps=100,
                            by_treatment=TRUE)

}
}
\references{
\itemize{
\item Bagiella, Emilia, and Daniel F. Heitjan. "Predicting analysis times in randomized clinical trials."
Statistics in medicine 20.14 (2001): 2055-2063.
\item Ying, Gui‐shuang, and Daniel F. Heitjan. "Weibull prediction of event times in clinical trials."
Pharmaceutical Statistics:
The Journal of Applied Statistics in the Pharmaceutical Industry 7.2 (2008): 107-120.

\item Chen, Tai-Tsang. "Predicting analysis times in randomized clinical trials with cancer immunotherapy."
BMC medical research methodology 16.1 (2016): 1-10.
}
}
