% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fat3.ad.dic.r
\name{fat3.ad.dic}
\alias{fat3.ad.dic}
\title{Fatorial triplo com um tratamento adicional em DIC}
\usage{
fat3.ad.dic(
  fator1,
  fator2,
  fator3,
  repet,
  resp,
  respAd,
  quali = c(TRUE, TRUE, TRUE),
  mcomp = "tukey",
  fac.names = c("F1", "F2", "F3"),
  sigT = 0.05,
  sigF = 0.05,
  unfold = NULL
)
}
\arguments{
\item{fator1}{Vetor numerico ou complexo contendo os niveis
do fator 1.}

\item{fator2}{Vetor numerico ou complexo contendo os niveis
do fator 2.}

\item{fator3}{Vetor numerico ou complexo contendo os niveis
do fator 3.}

\item{repet}{Vetor numerico ou complexo contendo as
repeticoes.}

\item{resp}{Vetor numerico ou complexo contendo a variavel
resposta.}

\item{respAd}{Vetor numerico ou complexo contendo a variavel
resposta do tratamento adicional.}

\item{quali}{Logico, se TRUE (default) na primeira posicao,
os niveis do fator 1 sao entendidos como qualitativos, se
FALSE, quantitativos; da mesma forma, a segunda posicao e
referente aos niveis do fator 2, e a terceira aos niveis do
fator 3.}

\item{mcomp}{Permite escolher o teste de comparacao multipla;
o \emph{default} e o teste de Tukey, contudo tem-se como
outras opcoes: o teste LSD ('lsd'), o teste LSDB ('lsdb'),
o teste de Duncan ('duncan'), o teste de SNK ('snk'), o
teste de Scott-Knott ('sk'), o teste de comparacoes
multiplas bootstrap ('ccboot') e o teste de Calinski e
Corsten baseado na distribuicao F ('ccf').}

\item{fac.names}{Permite nomear os fatores 1, 2 e 3.}

\item{sigT}{Significancia a ser adotada pelo teste de
comparacao multipla de medias; o default e 5\%.}

\item{sigF}{Significancia a ser adotada pelo teste F da
ANAVA; o default e 5\%.}

\item{unfold}{Orienta os desdobramentos apos a analise de
variancia. Se NULL (\emph{default}), sao feitas as analises
recomendadas; se '0', e feita apenas a analise de variancia;
se '1', os efeitos simples sao estudados; se '2.1', '2.2' ou
'2.3, as interaoes duplas 1, 2 ou 3 sao estudadas; se '3',
a interacao tripla e estudada.}
}
\value{
Sao retornados os valores da analise de variancia
do DIC em questao com um tratamento adicional,o teste de
normalidade de Shapiro-Wilk para os residuos do modelo, o
ajuste de modelos de regressao (caso de tratamentos
quantitativos) ou os testes de comparacao de medias (caso de
tratamentos qualitativos): teste de Tukey, teste de Duncan,
teste t de Student (LSD), teste t de Bonferroni, teste de
Student-Newman-Keuls (SNK), teste de Scott-Knott e teste de
comparacoes multiplas bootstrap; com o desdobramento da
interacao, caso esta seja significativa.
}
\description{
\code{fat3.ad.dic} Analisa experimentos em fatorial triplo
com um tratamento adicional em Delineamento Inteiramente
Casualizado balanceado, considerando o modelo fixo.
}
\details{
Os argumentos sigT e mcomp so serao utilizados
quando os tratamentos forem qualitativos.
}
\note{
O \code{\link{graficos}} pode ser usado para
construir os graficos da regressao e o
\code{\link{plotres}} para analise do residuo da anava.
}
\examples{
data(ex6)
attach(ex6)
data(respAd)
fat3.ad.dic(fatorA, fatorB, fatorC, rep, resp, respAd,
quali = c(TRUE, TRUE, TRUE), mcomp = "duncan", fac.names =
c("Fator A", "Fator B", "Fator C"), sigT=0.05, sigF = 0.05,
unfold=NULL)
}
\references{
HEALY, M. J. R. The analysis of a factorial
experiment with additional treatments. Journal of
Agricultural Science, Cambridge, v. 47, p. 205-206.
1956.
}
\seealso{
\code{\link{fat2.dic}}, \code{\link{fat2.dbc}},
\code{\link{fat3.dic}}, \code{\link{fat3.dbc}},
\code{\link{fat2.ad.dic}}, \code{\link{fat2.ad.dbc}},
and \code{\link{fat3.ad.dbc}}.
}
\author{
Eric B Ferreira,
\email{eric.ferreira@unifal-mg.edu.br}

Denismar Alves Nogueira

Portya Piscitelli Cavalcanti
}
