% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPDM.R
\name{est.tpdm}
\alias{est.tpdm}
\alias{est.row.tpdm}
\alias{est.element.tpdm}
\title{Estimation of TPDM}
\usage{
est.tpdm(X, Y = NULL, anz_cores = 1, clust = NULL, q = 0.98)

est.row.tpdm(x, Y, clust = NULL, q = 0.98)

est.element.tpdm(x, y, clust = NULL, q = 0.98)
}
\arguments{
\item{X}{A t x n dimensional, numeric data-matrix with t: Number of time steps and n: Number of grid points/stations}

\item{Y}{A t x n dimensional, numeric Data-matrix with t: Number of time steps and n: Number of grid points/stations}

\item{anz_cores}{Number of cores for parallel computing (default:1); Be careful not to overload your computer!}

\item{clust}{Optional: If clust = NULL, no declustering is performed. Else, declustering according to cluster-length 'clust'.}

\item{q}{Threshold for computation of TPDM. Only data above the 'q'-quantile will be used for estimation. Choose such that 0<q<1.}

\item{x}{Array of length t, where t is the number of time steps}

\item{y}{Same as x}
}
\value{
An n x n matrix, containing the estimate of the TPDM

Array containing the estimate of one row of the TPDM.

Value containing the estimate of one element of the TPDM.
}
\description{
Estimation of tail pairwise dependence matrix (TPDM)

Sub-Routine of \link{est.row.tpdm}. Calculates one element of the TPDM
}
\details{
Given a random vector X with components \eqn{x_{t,i}, x_{t,j}} with \eqn{i,j = 1, \ldots, n} and it's radial component \eqn{r_{t,ij} = \sqrt{x_{t,i}^2 + x_{t,j}^2}} and angular components \eqn{w_{t,i} = x_{t,i}/r_{t,ij}} and \eqn{w_{t,j} = x_{t,j}/r_{t,ij}}, the i'th,j'th element of the TPDM is estimated as:
\deqn{\hat{\sigma}_{ij} = 2 n_{ij,exc}^{-1} \sum_{t=1}^{n} w_{t,i} w_{t,j} |_{(r_{t,ij} > r_{0,ij})} }.
Given two random vectors X and Y with components \eqn{x_{t,i}, y_{t,j}} with \eqn{i,j = 1, \ldots, n}, and it's radial component \eqn{ r_{t,ij} = \sqrt{x_{t,i}^2 + y_{t,j}^2}} and angular components \eqn{ w_{t,i}^x = \frac{x_{t,i}}{r_{t,ij}} ; w_{t,j}^y = \frac{y_{t,j}}{r_{t,ij}}}, the i'th,j'th element of the cross-TPDM is estimated as:
\deqn{\hat{\sigma}_{ij} = 2 n^{-1}_{exc} \sum_{t=1}^{n} w^x_{t,i} w^y_{t,j} |_{(r_{t,ij} > r_{0,ij})} }.
}
\examples{
data    <- precipGER
\donttest{
data.alpha2       <- to.alpha.2(data$pr)
Sigma   <- est.tpdm(data.alpha2,anz_cores =1)}
}
\references{
Jiang & Cooley (2020) <doi:10.1175/JCLI-D-19-0413.1>; Szemkus & Friederichs (2023)
}
