% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{runElongationAnalysis}
\alias{runElongationAnalysis}
\title{run the elongation analysis.}
\usage{
runElongationAnalysis(
  fa,
  M,
  D1,
  D2,
  P,
  S16,
  E1,
  E2,
  E3,
  E4,
  E5,
  R2Thr = 0.9,
  maxiter = 10000,
  maxconvergence = 100,
  startpoints = 5,
  D2Thr = D2Thr
)
}
\arguments{
\item{fa}{data frame with isotope intensities for a FA. First two columns
correspond to Compound and Label information.}

\item{M}{total number of carbons for the FA.}

\item{D1}{positive numeric between 0 and 1 specifying the contribution of
acetate M+1. Estimated with \link{synthesisAnalysis}.}

\item{D2}{positive numeric between 0 and 1 specifying the contribution of
acetate M+2. Estimated with \link{synthesisAnalysis}.}

\item{P}{overdispersion parameter. Estimated with \link{synthesisAnalysis}.}

\item{S16}{fraction of newly synthesized C16 FA. If NA it is estimated.
It is set to 0 for n3 and n6 FA series.}

\item{E1}{fraction of elongated C18 FA from C16. If NA it is estimated.
It is set to 0 for n3 and n6 FA series.}

\item{E2}{fraction of elongated C20 FA from C18. If NA it is estimated.}

\item{E3}{fraction of elongated C22 FA from C20. If NA it is estimated.}

\item{E4}{fraction of elongated C24 FA from C22. If NA it is estimated.}

\item{E5}{fraction of elongated C26 FA from C24. If NA it is estimated.}

\item{R2Thr}{positive numeric between 0 and 1 specifying the minimum R2
allowed for fits.}

\item{maxiter}{parameter passed to \link[stats]{nls.control}. Positive integer
specifying the maximum number of iterations allowed.}

\item{maxconvergence}{positive integer specifying the maximum number of
successes before choosing the winning model.}

\item{startpoints}{positive integer specifying the number of starting points
for each parameter to be estimated.}

\item{D2Thr}{minimum D2 value allowed to perform the elongation analysis.}
}
\value{
Elongation and importation analysis results.
}
\description{
run the elongation analysis.
}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
\keyword{internal}
