% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fardeep.R
\name{fardeep}
\alias{fardeep}
\title{Using the idea of least trimmed square to detect and remove outliers before estimating the coefficients.
A robust method for gene-expression deconvolution.}
\usage{
fardeep(X, Y, alpha1 = 0.1, alpha2 = 1.5, up = 10, low = 1,
  nn = TRUE, intercept = TRUE, lognorm = TRUE, permn = 100,
  QN = FALSE)
}
\arguments{
\item{X}{input matrix of predictors with n rows and p columns.}

\item{Y}{input vector of dependent variable.}

\item{alpha1}{parameter used to adjust the upper bound of outliers. Take value from 0 to 1, default 0.1.}

\item{alpha2}{parameter used to adjust the lower bound of outliers. Take value larger than 1, default 1.5.}

\item{up}{upper bound of parameter k in function alts, default 10.}

\item{low}{lower bound of parameter k in function alts, default 1.}

\item{nn}{whether coefficients are non-negative,default TRUE.}

\item{intercept}{whether intercept is included in model, default TRUE.}

\item{lognorm}{whether noise is log-normal distributed, default TRUE.}

\item{permn}{the number of permutation to get the p-values, default TRUE.}

\item{QN}{whether perform quantile normalization, default TRUE.}
}
\value{
abs.beta:  estimation of abosulute abundance of cells (TIL subset scores).

relative.beta:  estimation of relative proportions by normalizing abs.beta to 1.

pval:  statistical significance for the deconvolution result.

k.value:  tuned paprameter by modified BIC.
}
\description{
Using the idea of least trimmed square to detect and remove outliers before estimating the coefficients.
A robust method for gene-expression deconvolution.
}
\examples{
library(FARDEEP)
data(LM22)
data(mixture)
# toy examples
result = fardeep(LM22, mixture[, 1:2], permn = 0)
\donttest{
result = fardeep(LM22, mixture)
coef = result$abs.beta
}
}
\references{
Yuning Hao, Ming Yan, Blake R. Heath, Yu L. Lei and Yuying Xie. Fast and Robust Deconvolution of Tumor Infiltrating Lymphocyte from Expression Profiles using Least Trimmed Squares. <doi:10.1101/358366>
}
\author{
Yuning Hao, Ming Yan, Blake R. Heath, Yu L. Lei and Yuying Xie
}
