% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propagateC++.R
\name{propagate}
\alias{propagate}
\title{Propagate the Fleming-Viot latent signal in time}
\usage{
propagate(fvddp, delta.t)
}
\arguments{
\item{fvddp}{An instance of class  generated via \code{\link[=initialize]{initialize()}}. In order to
perform the propagation, the FVDDP has to be fed some data using
\code{\link[=update]{update()}}, at least once.}

\item{delta.t}{The non-negative time of the propagation. If 0, the returned
process is the input.}
}
\value{
A list of the same class to the one given as an input (\code{fvddp}). The
amount of rows of the matrix \code{M}, as well as the vector of weights, \code{w}, will
increase. The hyperparameters will be the same.
}
\description{
Propagate the Fleming-Viot latent signal in time
}
\examples{
FVDDP = initialize(1, function(x) rpois(x, 3),
                   function(x) dpois(x, 3), TRUE)
FVDDP = update(FVDDP, c(4,5))
propagate(FVDDP, 0.2)

FVDDP = initialize(3, function(x) rnorm(x, -1,3),
                   function(x) dnorm(x, -1, 3), FALSE)
FVDDP = update(FVDDP, c(-1.145, 0.553, 0.553, 0.553))
propagate(FVDDP, 0.6)

}
\references{
{
\insertRef{PapaspiliopoulosRuggieroSpanò2016}{FVDDPpkg}
}
}
\seealso{
\code{\link[=approx.propagate]{approx.propagate()}} for a (faster) Monte-Carlo-based analogous.
}
