\name{plot.simfam2}
\alias{plot.simfam2}
\title{Plot method for \code{simfam2} or Plot pedigrees}
\description{
Provides pedigree plots for specified families generated from \code{simfam2} function with option to save plots into a pdf file.
}
\usage{
\method{plot}{simfam2}(x, famid, pdf = FALSE, file = NULL, \ldots)
}
\arguments{
 \item{x}{An object of class \code{'simfam2'} created by \code{\link{simfam2}} function or a data frame that has class attributes \code{c("simfam2", "data.frame")}.
}
 \item{famid}{List of family IDs to plot. Default is the first family in given data set.}
 \item{pdf}{Logical; if \code{TRUE}, pedigree plots are saved in a pdf file. If \code{FALSE}, plot pedigrees on current plotting device. Default is \code{FALSE}.}
 \item{file}{File name to save the pedigree plots; Default file name is \code{"pedigreeplot.pdf"}.}
 \item{...}{Additional arguments passed on to the plot function.}
 
}

\details{
Argument \code{x} can be a data frame that contains \code{famID}, \code{indID}, \code{fatherID},  \code{motherID}, \code{gender} (1 for male, 0 for female), \code{status} (1 for affected, 0 for non-affected), \code{mgene} (1 for mutation carrier, 0 for non-carrier, \code{NA} for missing), and \code{proband} (1 for proband, 0 for non-proband) and should have class attributes \code{class(x) <- c("simfam", "data.frame")}.

Optionally, the data frame can contain a column named \code{carrp.geno} or \code{carrp.pheno} to replace missing values in \code{mgene} with their carrier probabilities.
}

\value{
Returns pedigree plots for specified families created by \code{\link{simfam2}} function or for the data frame provided along with the affection and carrier mutation statuses of family members. Probands from each pedigree are indicated using red color.

When object inlcudes \code{carrp.geno} and/or \code{carrp.pheno} generated by \code{\link{carrierprob}} function, the \code{plot} function displays the carrier probabilities for those with missing carrier status.
}


\seealso{
\code{\link{simfam2}, \link{summary.simfam2}, \link{carrierprob}}	
}

\examples{

set.seed(4321)

data <- simfam(N.fam = 10, design = "noasc", variation = "none",
         base.dist = "Weibull", base.parms = c(0.016, 3), vbeta = c(1, 1))

IBDmatrix <- diag(1, dim(data)[1])
data <- data[ , c(1:7, 11, 14)]

fam2 <- simfam2(inputdata = data, IBD = IBDmatrix, design = "pop", 
        variation = c("kinship","IBD"), depend = c(1, 1), 
        base.dist = "Weibull", base.parms = c(0.016, 3),
        var_names = c("gender", "mgene"), vbeta = c(1,1),
        agemin=20) 

plot(fam2, famid = c(1:2))

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ Pedigree plot }
