% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b_fatreturns.R
\name{fatreturns}
\alias{fatreturns}
\alias{logreturns}
\alias{replaceNA}
\title{Simple and Elaborated Prices to Returns}
\usage{
fatreturns(x, log = TRUE, per = "cent", e = NULL, dfrcol = 1,
  na.rm = TRUE)

logreturns(x)

replaceNA(x)
}
\arguments{
\item{x}{The prices (vector, data.frame, matrix, timeSeries, xts, zoo, list).}

\item{log}{boolean. log returns or percentage returns.}

\item{per}{character. Either "one", "cent, "thousand", "tenthousand" or 
"o", "c", "th", "te". Multiply the result by 1, 100, 1000, 10000.}

\item{e}{NULL or positive numeric. NULL is for no change \code{f(x)=x}. 
A positive numeric designates the focal point of the hyperbola 
to turn negative prices into positive prices, keeping the hierarchy:  
\code{f(x)=(x+sqrt(x*x+e*e))/2}. There is currently no rules of thumb 
for the optimal value of \code{e}. See \code{\link{elevate}}.}

\item{dfrcol}{integer. For data.frame only, designates the column that handles the time 
and must be processed separately. Use \code{dfrcol = 0} if all columns 
must be processed and there is no time (or turn the data.frame to a matrix).}

\item{na.rm}{boolean. Replace \code{x[t]=NA} with the previous non-NA value available 
in the price serie such that \code{(x[t-1], x[t]=x[t-1], x[t+1])} and 
calculate the returns accordingly. Force 0 in the first line of the returns 
if \code{x[1]=NA}.}
}
\description{
\code{fatreturns} is an elaborated function to compute prices to returns. 
It includes a pre-treatment for negative prices. 
It computes either log-returns (default) or percentage-returns. 
It handles properly NA values in the input vector, replacing them by 0
in the output vector. Doing so, it warrants that the sum of the log-returns 
(when selected) is equal to the difference of the log-prices. 
It works with vector, matrix, data.frame, timeSeries, xts, zoo, list, list of lists 
and even list of vector, data.frame, timeSeries, xts, zoo mixed together.
The returned object is of same dimension and same class than the input object 
with the first line filled with 0.
The results may be as per one, per cent (default), per thousand and per ten thousand. 

\code{logreturns} is an improved version of function \code{100*diff(log(x))} to handle 
vector, matrix, data.frame and list. It handles properly the first line and the NA values. 
It does not control time, rownames and colnames but may return them.
}
\examples{

fatreturns(extractData())
logreturns(extractData())

}
