% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_correlation_matrix.R
\name{group_cor_mat}
\alias{group_cor_mat}
\title{Simulate a reduced rank correlation matrix with multiple groups}
\usage{
group_cor_mat(
  n = c(5, 5),
  within.cor = 0.5,
  between.cor = 0.2,
  range = NULL,
  rank = 4,
  skew = 0,
  pos.def = FALSE,
  small.positive = NULL,
  return.groups = FALSE
)
}
\arguments{
\item{n}{A vector defining the size of each group.}

\item{within.cor}{A vector defining the baseline correlation within each group.
If only one value is supplied, all groups will be assigned the same correlation. \cr
\strong{Note:} \code{-1 < within.cor < 1}.}

\item{between.cor}{A scalar defining the baseline correlation between groups. \cr
\strong{Note:} \code{between.cor <= within.cor}.}

\item{range}{A scalar defining the range of correlations around the baseline. By default,
\code{range = 1 - max(within.cor)} which ensures the matrix is positive semi-definite.
\strong{Note:} \code{max(within.cor) + range <= 1}.}

\item{rank}{A scalar defining the rank of the correlation matrix.}

\item{skew}{A scalar defining the skewness imposed on the correlations.
\strong{Note:} \code{-1 < skew < 1}.}

\item{pos.def}{When \code{TRUE} (default is \code{FALSE}), the function \code{bend} of the R package
\href{https://cran.r-project.org/package=mbend}{`mbend`} is used to
bend a non-positive (semi)-definite matrix to be positive (semi)-definite.}

\item{small.positive}{Argument passed to \code{bend} when \code{pos.def = TRUE} (default is 1e-8).
Eigenvalues smaller than \code{small.positive} are replaced by this. \cr
\strong{Note:} \code{0 < small.positive < 0.1}.}

\item{return.groups}{When \code{TRUE} (default is \code{FALSE}), a list is returned with additional
entries containing the members of each group.}
}
\value{
A symmetric correlation matrix with defined rank and groupings.
  When \code{pos.def = TRUE}, the correlation matrix is guaranteed to be positive (semi)-definite.
  When \code{return.groups = TRUE}, a list is returned with additional entries containing the group members.
}
\description{
Creates a symmetric correlation matrix with user-defined structure, rank and groupings.
}
\examples{
# Simulate and visualise a correlation matrix with 2 groups containing 5 and 10 members,
# correlations of 0.4 within groups and 0 between groups and rank equal to 4
cor_ls <- group_cor_mat(
  n = c(5, 10),
  within.cor = 0.4,
  between.cor = 0,
  rank = 4,
  return.groups = TRUE
)

plot_matrix(
  mat = cor_ls$cor.mat,
  group.df = cor_ls$group.df,
  order = TRUE
)

}
