% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NA.count.runs.R
\name{NA.count.runs}
\alias{NA.count.runs}
\title{Sum missing data points from a daily time series}
\usage{
NA.count.runs(input, by = "hyear", hyrstart = 1)
}
\arguments{
\item{input}{output from \code{\link{NA.runs}}}

\item{by}{character string identifying the time period to summarize by.
Defaults is hydrologic year ("hyear"), other choices are "year" and "month".
The "month" option will return the number of missing data points for each
month in the time series.}

\item{hyrstart}{optional argument, define start month of hydrologic year}
}
\value{
Returns a numeric vector of the number of missing observations per
  summary period.  The "times" attribute of the returned vector provides the
  corresponding year, hyear, or month.
}
\description{
Counts the number of missing data points by calendar year, hydrologic year, or month
}
\examples{
data(caniapiscau)
cania.ts <- create.ts(caniapiscau)
res <- NA.runs(cania.ts)
print(res)
res2 <- NA.count.runs(res)
print(res2)
}
\seealso{
\code{\link{NA.runs}}
}
\author{
Jennifer Dierauer
}
