% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_export.R
\name{commat}
\alias{commat}
\alias{commat_index}
\title{Commutation matrix}
\usage{
# Commutation matrix
commat(r, c)

# Vector of indexes for the rows of commutation matrix
commat_index(r, c)
}
\arguments{
\item{r}{Number of rows of \eqn{\mathbf{Y}}.}

\item{c}{Number of columns of \eqn{\mathbf{Y}}.}
}
\value{
A sparse (\eqn{r c \times r c}) matrix \eqn{\mathbf{P}} (\link{commat}),
or the vector of indexes for the rows of commutation matrix \eqn{\mathbf{P}}
(\link{commat_index})
}
\description{
This function returns the (\eqn{r c \times r c})
commutation matrix \eqn{\mathbf{P}} such that
\eqn{\mathbf{P} \mbox{vec}(\mathbf{Y}) = \mbox{vec}(\mathbf{Y}'),}
where \eqn{\mathbf{Y}} is a (\eqn{r \times c}) matrix (Magnus and Neudecker, 2019).
}
\examples{
Y <- matrix(rnorm(30), 5, 6)
P <- commat(5, 6)
P \%*\% as.vector(Y) == as.vector(t(Y)) # check

}
\references{
Magnus, J.R. and Neudecker, H. (2019), Matrix Differential Calculus with Applications
in Statistics and Econometrics, third edition, New York, Wiley, pp. 54-55.
}
\seealso{
Utilities: 
\code{\link{FoReco2matrix}()},
\code{\link{aggts}()},
\code{\link{balance_hierarchy}()},
\code{\link{csprojmat}()},
\code{\link{cstools}()},
\code{\link{ctprojmat}()},
\code{\link{cttools}()},
\code{\link{df2aggmat}()},
\code{\link{lcmat}()},
\code{\link{recoinfo}()},
\code{\link{res2matrix}()},
\code{\link{set_bounds}()},
\code{\link{shrink_estim}()},
\code{\link{shrink_oasd}()},
\code{\link{teprojmat}()},
\code{\link{tetools}()},
\code{\link{unbalance_hierarchy}()}
}
\concept{Utilities}
