% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proj_matrix.R
\name{csprojmat}
\alias{csprojmat}
\title{Projection matrix for optimal combination cross-sectional reconciliation}
\usage{
csprojmat(agg_mat, cons_mat, comb = "ols", res = NULL, mat = "M", ...)
}
\arguments{
\item{agg_mat}{A (\eqn{n_a \times n_b}) numeric matrix representing the cross-sectional
aggregation matrix. It maps the \eqn{n_b} bottom-level (free)
variables into the \eqn{n_a} upper (constrained) variables.}

\item{cons_mat}{A (\eqn{n_a \times n}) numeric matrix representing the cross-sectional
zero constraints: each row represents a constraint equation, and each column represents
a variable. The matrix can be of full rank, meaning the rows are linearly independent,
but this is not a strict requirement, as the function allows for redundancy in the
constraints.}

\item{comb}{A string specifying the reconciliation method. For a complete list, see \link{cscov}.}

\item{res}{An (\eqn{N \times n}) optional numeric matrix containing the in-sample
residuals. This matrix is used to compute some covariance matrices.}

\item{mat}{A string specifying which matrix to return:
"\code{M}" (\emph{default}) for \eqn{\mathbf{M}} and "\code{G}" for \eqn{\mathbf{G}}.}

\item{...}{
  Arguments passed on to \code{\link[=cscov]{cscov}}
  \describe{
    \item{\code{mse}}{If \code{TRUE} (\emph{default}) the residuals used to compute the covariance
matrix are not mean-corrected.}
    \item{\code{shrink_fun}}{Shrinkage function of the covariance matrix, \link{shrink_estim} (\emph{default}).}
  }}
}
\value{
The projection matrix \eqn{\mathbf{M}} (\code{mat = "M"}) or
the mapping matrix \eqn{\mathbf{G}} (\code{mat = "G"}).
}
\description{
This function computes the projection or the mapping matrix
\eqn{\mathbf{M}} and \eqn{\mathbf{G}}, respectively, such that
\eqn{\widetilde{\mathbf{y}} = \mathbf{M}\widehat{\mathbf{y}} = \mathbf{S}_{cs}\mathbf{G}\widehat{\mathbf{y}}},
where \eqn{\widetilde{\mathbf{y}}} is the vector of the reconciled forecasts,
\eqn{\widehat{\mathbf{y}}} is the vector of the base forecasts,
\eqn{\mathbf{S}_{cs}} is the cross-sectional structural matrix, and \eqn{\mathbf{M} = \mathbf{S}_{cs}\mathbf{G}}.
For further information regarding on the structure of these matrices,
refer to Girolimetto et al. (2023).
}
\examples{
# Cross-sectional framework
A <- t(c(1,1)) # Aggregation matrix for Z = X + Y
Mcs <- csprojmat(agg_mat = A, comb = "ols")
Gcs <- csprojmat(agg_mat = A, comb = "ols", mat = "G")

}
\references{
Girolimetto, D., Athanasopoulos, G., Di Fonzo, T. and Hyndman, R.J. (2024),
Cross-temporal probabilistic forecast reconciliation: Methodological and
practical issues. \emph{International Journal of Forecasting}, 40, 3, 1134-1151.
\doi{10.1016/j.ijforecast.2023.10.003}
}
\seealso{
Utilities: 
\code{\link{FoReco2matrix}()},
\code{\link{aggts}()},
\code{\link{balance_hierarchy}()},
\code{\link{commat}()},
\code{\link{cstools}()},
\code{\link{ctprojmat}()},
\code{\link{cttools}()},
\code{\link{df2aggmat}()},
\code{\link{lcmat}()},
\code{\link{recoinfo}()},
\code{\link{res2matrix}()},
\code{\link{set_bounds}()},
\code{\link{shrink_estim}()},
\code{\link{shrink_oasd}()},
\code{\link{teprojmat}()},
\code{\link{tetools}()},
\code{\link{unbalance_hierarchy}()}
}
\concept{Utilities}
