% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_ccircle_spatial.R
\name{fe_ccircle_spatial}
\alias{fe_ccircle_spatial}
\title{User Friendly Construction of an \strong{fe_ccircle_spatial} Object from a List of
Data Frames}
\usage{
fe_ccircle_spatial(
  x,
  method = c("strict", "flexible"),
  tree_frame_name = "trees",
  tree_pos_frame_name = "tree_positions",
  circle_frame_name = "circle_definition",
  center_coord = "center_coordinate",
  small_trees_name = "small_trees",
  time_yr_name = "time_yr",
  tree_id_col,
  species_id_col,
  time_yr_col,
  dbh_cm_col,
  radius_col,
  angle_col,
  stand_id = "my_fe_ccircle_spatial",
  layer_key_col = NA,
  age_yr_col = NA,
  height_m_col = NA,
  crown_base_height_m_col = NA,
  crown_radius_m_col = NA,
  removal_col = NA,
  ingrowth_col = NA,
  n_rep_ha_col = NA,
  verbose = TRUE
)
}
\arguments{
\item{x}{named list of two data frames to be coerced into the goal object. One
data frame must contain the single tree data; it has the same requirements
as for the input data frame \code{x} of the function \code{\link{fe_stand}}
or  \code{\link{fe_stand_spatial}}. Another data frame must contain the tree
positions.}

\item{method}{name of the method for dealing with trees without positions. If
method = "flexible" the validator issues a warning. By default (method =
"strict"), all trees must have defined positions and the validator issues an
error. Trees without positions are typically trees below a certain dbh
threshold. Note that this check applies only to trees that actually have a
dbh, not to trees in the \code{small_trees} slot of an
\code{fe_ccircle_spatial object}.}

\item{tree_frame_name}{name of the data frame in \code{x} that contains the
single tree data (default: "trees")}

\item{tree_pos_frame_name}{name of the data frame in \code{x} that contains
the tree positions (default: "tree_positions"), it must contain the tree_id
the radius and the angle in polar coordinates. The angle must be
defined in degrees with the Y-Axis as North (anti-clockwise) and
the radius in meters.}

\item{circle_frame_name}{name of the data frame in \code{x} that contains the
definition of the concentric circles. It must contain the lower and the
upper dbh limits, the circle area in Ha, and the slope in degrees. If the
slope is not given it will be set to 0.}

\item{center_coord}{name of the sf object that contains the center coordinate
of the circles with coordinate reference system (either Gauss Kruger or
UTM). If it is not provided the center will be c(0,0) by the default}

\item{small_trees_name}{name of the object that contains the information
regarding the small trees (generally those trees that do no have any dbh
because of having a height below 1.3 m). This object is still experimental,
so the only requirement for it is that it has to be a data frame with at
least one row with column names. Useful standard information in this data
frame are the tree id, the height and representation area.}

\item{time_yr_name}{name of the element of \code{x} which contains the
required time information, i.e. a single (calendar) year or vector of years
in order to give the object a time relation. If small tree information is
present (i.e. the small tree data frame is not empty), \code{time_yr} must
absolutely match with the \code{time_yr} column of this data frame.}

\item{tree_id_col}{name of the column in the trees and tree_positions data
frames  which contains the tree id's (\code{character}, required, must not
contain missing values)}

\item{species_id_col}{name of the column in trees data frame which contains
the species id's. Must be an object of one  of the \code{fe_species} classes
supported by this package. This column is required, must not contain missing
values.}

\item{time_yr_col}{name of the column in the trees data frame which provides
time information in years (\code{character}, required, must not contain
missing values)}

\item{dbh_cm_col}{name of the column in the trees data frame which contains
the dbh in cm (\code{character}, required, must not contain missing values)}

\item{radius_col}{name of the column in the tree positions data frame that
contains the distance to the center of the plot (\code{character}).}

\item{angle_col}{name of the column in the tree positions data frame that
contains the angle coordinate of the tree in polar coordinates. The angle
must be measured respect to the x axis and anticlockwise (\code{character}).}

\item{stand_id}{arbitrary id of the stand (\code{character}, default:
"my_fe_ccircle_spatial")}

\item{layer_key_col}{name of the column in \code{x} that contains codes for
the stand layer a given tree belongs to. These codes are whole numbers.
The following values are allowed: 1 - Main stand, 2 - Understorey,
3 - Pregeneration (ger: "Vorausverjuengung"), 4 - Remnant trees, hold over
trees, veteran trees (ger: "Nachhiebsreste", "Ueberhaelter", "Altbaeume").
Must not contain missing values if provided. If not provided, it will be
set to 1 (main stand) for every tree.}

\item{age_yr_col}{name of the column in the trees data frame which provides
the tree ages in years (\code{character}, optional, may contain missing
values)}

\item{height_m_col}{name of the column in the trees data frame which provides
the tree heights in m (\code{character}, optional, may contain missing
values)}

\item{crown_base_height_m_col}{name of the column in the trees data frame
which provides the crown base heights in m (\code{character}, optional, may
contain missing values)}

\item{crown_radius_m_col}{name of the column in the trees data frame which
provides the crown radii in m (\code{character}, optional, may contain
missing values)}

\item{removal_col}{name of the column in the trees data frame which provides
the tree's removal status. If \code{TRUE}, this indicates the tree was
removed or dead at the time indicated in \code{age_yr_col}
(\code{character}, optional, must not contain missing values if provided).
If not provided, the removal status will be \code{FALSE} for all trees in
the resulting \code{fe_ccircle_spatial} object.}

\item{ingrowth_col}{name of the column in the trees data frame which provides
the tree's ingrowth status. If \code{TRUE}, this indicates a tree that grew
newly in at the time indicated in \code{age_yr_col} (\code{character},
optional, must not contain missing values if provided). If not provided, the
ingrowth status will be \code{FALSE} for all trees in the resulting
\code{fe_ccircle_spatial} object.}

\item{n_rep_ha_col}{name of the column in the trees data frame which provides
each tree's representation number per ha. n_rep_ha will be always
recalculated based on the representation area of each of the concentric
circles.}

\item{verbose}{name of the column in the trees data frame which provides the
tree's ingrowth status. If \code{TRUE}, this indicates a tree that grew
newly in at the time indicated in \code{age_yr_col} (\code{character},
optional, must not contain missing values if provided). If not provided, the
ingrowth status will be \code{FALSE} for all trees in the resulting
\code{fe_ccircle_spatial} object.}
}
\value{
If the user input allows to construct a well-defined
\code{fe_ccircle_spatial} object, this object will be returned. If not, the
function will terminate with an error.
}
\description{
\code{fe_ccircle_spatial()} provides a user-friendly interface for the
constructor \code{\link{new_fe_ccircle_spatial}}. While the constructor does
not prevent users from creating malformed \code{fe_ccircle_spatial} objects,
\code{fe_ccircle_spatial} does everything to achieve a well-defined object
mostly based on an initial list of data.frames that might be, e.g. drawn out
of a user's own data base.
}
\details{
An object of class \code{fe_ccircle_spatial} is a child object of
\code{fe_stand_spatial} which, however, contains information about the
horizontal positions of the trees in a concentric circle representation
scheme. All spatial information and its processing is based on the R-package
\href{https://CRAN.R-project.org/package=sf}{sf}.

The input object \code{x} to \code{fe_ccircle_spatial} must be a list that
comprises two and an optional third data frame(s): \itemize{ \item a data
frame containing the single tree information (same requirements as for
\code{\link{fe_stand}}). This data frame must contain a a minimum set of
columns (tree id, species id, time variable, diameter at breast height). These
columns must not contain missing values. Other columns (containing tree
height, height to crown base, crown radius, tree age) are optional for the
user to provide. If provided, they may contain missing values. If not
provided, these columns will only contain missing values in the
\code{fe_ccircle_spatial} object. The columns about the trees' removal and
ingrowth status are also optional, but if provided, they must \emph{not} contain
missing values. If not provided, both columns will be filled with \code{FALSE}
in the resulting \code{fe_ccircle_spatial} object.
\code{fe_ccircle_spatial} will automatically add a column \code{n_rep_ha}
which contains for each tree the number of trees it represents per ha. This
may seem redundant if looking at \code{fe_ccircle} objects alone, but it
allows a broad range of evaluation functions to be applied to different
objects containing trees. In addition to the input object of
\code{\link{fe_ccircle_spatial}}, there is one additional list element needed
which defines a single (calendar) year or a vector of years in order to give
the object a time relation. If small tree information is present (i.e. the
small tree data frame is not empty), \code{time_yr} must absolutely match
with the \code{time_yr} column of this data frame.

\item a data frame that contains information about the tree positions. This is
not part of the first data frame, because the latter could contain several
observations (at different times) of the same tree, which would lead to
redundant coordinate representation. This data frame must contain a column
with tree id's, and the x and y coordinates of the stem center points.
\code{NA} values are not allowed in this data frame.}
}
\examples{

# Transform the example data collection mm_forest_1_raw (could e.g. have
# been drawn out of a user's data base) into an fe_ccircle_spatial object

spruce_pine_ccircle_sp <- spruce_pine_ccircle_raw |>
  fe_ccircle_spatial(
    method = "flexible",
    tree_id_col = "tree_id",
    species_id_col = "species_id",
    time_yr_col = "time_yr",
    dbh_cm_col = "dbh_cm",
    radius_col = "R",
    angle_col = "angle",
    stand_id = mm_forest_1_raw$stand_id,
    height_m_col = "height_m",
    removal_col = "removal",
    time_yr_name = "time_yr"
  )
# Show a little summary, display scientific species names
options(fe_spec_lang = "sci")
spruce_pine_ccircle_sp |> summary()

}
