% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fe_yield_table.R
\name{plot.fe_yield_table}
\alias{plot.fe_yield_table}
\title{Plot an fe_yield_table Object}
\usage{
\method{plot}{fe_yield_table}(x, variable = NA, ...)
}
\arguments{
\item{x}{An object of class \code{\link{fe_yield_table}}}

\item{variable}{Character, name of the variable to be plotted, default is
\code{NA}, which plots the variable listed first in the fe_yield_table
object's \code{site_index_variable slot}.}

\item{...}{Other parameters, not used}
}
\value{
An object of class ggplot
}
\description{
Plot an fe_yield_table Object
}
\examples{
  fe_ytable_pine_wiedemann_moderate_1943 |> plot()
  fe_ytable_pine_wiedemann_moderate_1943 |> plot(variable = "ba_m2_ha")
  fe_ytable_pine_wiedemann_moderate_1943 |> plot(variable = "mai_m3_ha_yr")

  # Modify plot post hoc ...
  fe_ytable_pine_wiedemann_moderate_1943 |> plot(variable = "n_ha")
  # ... better to read on log scale
  fe_ytable_pine_wiedemann_moderate_1943 |> plot(variable = "n_ha") +
    ggplot2::scale_y_log10()

}
\seealso{
Other yield table functions: 
\code{\link{fe_yield_table}()},
\code{\link{si_to_mai_age}()},
\code{\link{si_to_mai_max}()},
\code{\link{site_index}()},
\code{\link{stocking_level}()},
\code{\link{yield_tables_for_species}},
\code{\link{ytable_age_slice}()},
\code{\link{ytable_lookup}()},
\code{\link{ytable_max_slice}()}
}
\concept{yield table functions}
