% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fracfixr.r
\name{PlotFractions}
\alias{PlotFractions}
\title{PlotFractions: Visualize Fraction Proportions}
\usage{
PlotFractions(FracFixed)
}
\arguments{
\item{FracFixed}{Output from FracFixR() function}
}
\value{
ggplot2 object showing fraction proportions
}
\description{
Creates a stacked bar plot showing the distribution of RNA across fractions
for each replicate, including the "lost" fraction.
}
\examples{
data(example_counts)
data(example_annotation)

# Run FracFixR
results <- FracFixR(example_counts, example_annotation, parallel=FALSE)
# Create fraction plot
frac_plot <- PlotFractions(results)
# Save plot with ggsave("fractions.pdf", frac_plot, width = 10, height = 8)

}
