% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FracMatrix.R
\name{FracMatrix}
\alias{FracMatrix}
\title{FracMatrix}
\usage{
FracMatrix(H, K, X)
}
\arguments{
\item{H}{Hurst parameter (a real in interval [0,1))}

\item{K}{number of observations}

\item{X}{Coordinates}
}
\value{
Returns a fractional distance matrix, which depends on the Hurst parameter.
}
\description{
Fractional distance matrix
}
\examples{
# Load FracKrigingR library
library(FracKrigingR)
#Fractional Brownian vector field
    K = 10; H = 0.5; p = 2
#Generate coordinates
    X<-matrix(0,ncol=p, nrow=K)
    for(j in 1:p){
        for(i in 1:K){
            X[i,j] = rnorm(1, 0, 1)
        }
    }
    FracMatrix(H, K, X)
}
