% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha_diversity.R
\name{compute_alpha_div}
\alias{compute_alpha_div}
\title{Convenience function for running default alpha diversity metrics on a single vector input}
\usage{
compute_alpha_div(x, metric, ...)
}
\arguments{
\item{x}{input vector. Either class numeric (representing abundance of categories [e.g., microbes]) or character (indicating which taxa are present, which is required for \code{faiths_pd}).}

\item{metric}{alpha diversity metric to compute. Must be one of \code{names(FuncDiv_alpha_metrics)}.}

\item{...}{included so that functions with single arguments will not throw errors if \code{tree} is included (and ignored). This should be a phylo object to use in case of \code{faiths_pd}.}
}
\value{
numeric vector with alpha diversity value.
}
\description{
This is a simple wrapper for \code{FuncDiv_alpha_metrics}, and you can see more details with \code{?FuncDiv_alpha_metrics}.
}
\details{
These functions all have a single input: a numeric vector containing taxa abundances within a given sample.
The exception is for \code{faiths_pd}, which expects a character vector of taxa labels that are present, as well as a tree (phylo object),
which must contain all these specified taxa labels as tip labels.
}
\examples{
# Most metrics just require an input vector of abundances.
test_abun <- c(0, NA, 1, 2, 10, 4)
compute_alpha_div(x = test_abun, metric = "richness")

# Note that the input for computing Faith's PD is different.
# Get a randomly generated tree:
test_tree <- ape::rtree(n = 50)
test_present_tips <- c('t1', 't2', 't3')
compute_alpha_div(x = test_present_tips, metric = "faiths_pd", tree = test_tree)

}
