% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{contrib_to_multitab}
\alias{contrib_to_multitab}
\title{Utility function to convert from contributional to multi-table input objects}
\usage{
contrib_to_multitab(
  contrib_tab,
  samp_colname = "sample",
  func_colname = "function.",
  abun_colname = "taxon_abun",
  taxon_colname = "taxon",
  copy.num_colname = "genome_function_count"
)
}
\arguments{
\item{contrib_tab}{data.frame object containing combined taxa abundances and function copy numbers across taxa. Must contain columns corresponding to the sample ids, function ids, taxa ids, and taxa
abundances within samples. These column names are specified by the \code{samp_colname}, \code{func_colname}, \code{taxon_colname}, \code{abun_colname}, and \code{copy.num_colname}, respectively.}

\item{samp_colname}{sample id column name of \code{contrib_tab} input data.frame.}

\item{func_colname}{function id column name of \code{contrib_tab} input data.frame.}

\item{abun_colname}{taxonomic abundance (within each sample) column name of \code{contrib_tab} input data.frame.}

\item{taxon_colname}{taxon id column name of \code{contrib_tab} input data.frame.}

\item{copy.num_colname}{function copy number column name of \code{contrib_tab} input data.frame.}
}
\value{
list with taxon abundance (\code{taxon_abun}) and function copy number (\code{function_copy_num}) data.frames as separate elements.
}
\description{
Converts from contributional-type table (i.e., a single, long table with joint taxa/function information) to separate taxa abundance and function copy number tables.
}
