% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{evaluation}
\alias{evaluation}
\title{Evaluate the fitness of a population}
\usage{
evaluation(Pop, X, XtX = NULL, lambda, grad.control = list(tol.obj = 1e-06,
  max.ite = 50), ncores = 1)
}
\arguments{
\item{Pop}{Population of permutations from [1,p]: matrix with \code{pop.size} rows and p columns, each row corresponding to one permutation of the population.}

\item{X}{Design matrix, with samples (n) in rows and variables (p) in columns.}

\item{XtX}{(optional) Cross-product of X; computed if not provided.}

\item{lambda}{Parameter of penalization (>0).}

\item{grad.control}{A list containing the parameters for controlling the inner optimization, i.e. the gradient descent
\itemize{
\item{\code{tol.obj.inner}}{ tolerance (>0),}
\item{\code{max.ite.inner}}{ maximum number of iterations (>0).}
}}

\item{ncores}{Number of cores (>1, depending on your computer).}
}
\value{
A list with the following elements:
\itemize{
\item{Tpop}{ Matrix with pxp columns, each column corresponding to the best triangular matrix (in a vector form) associated to each permutation of the population.}
\item{f}{ Fitness of the population.}
}

A list with the following elements:
\itemize{
\item{\code{Tpop}}{ Matrix with p rows and pop.size columns, each column corresponding to the best triangular matrix (in a vector form) associated to each permutation of the population.}
\item{\code{f}}{ Fitness of the population.}
}
}
\description{
Internal function of the genetic algorithm that evaluates the fitness (penalized log-likelihood) of a set (population) of permutations. It internally computes the best triangular matrix associated to each permutation of the population.
}
\examples{
 #############################################################
 # Loading toy data
 #############################################################
 data(toy_data)
 # toy_data is a list of two matrices corresponding to a "star"
 # DAG (node 1 activates all other nodes):
 # - toy_data$X is a 100x10 design matrix
 # - toy_data$G is the 10x10 adjacency matrix (ground trough)

 ########################################################
 # Creating a population of permutations
 ########################################################
 # first, define the parameters
 p <- ncol(toy_data$G) # number of nodes
 pop.size <- 10 # population size

 # then create your population of permutations
 Pop <- matrix(data = 0, nrow = pop.size, ncol = p)
 for(i in 1:pop.size){
     Pop[i,] = sample(p)
 }

 ########################################################
 # Evaluating the fitness of the population
 ########################################################
 # evaluation of the whole population
 Evaluation <- evaluation(Pop=Pop,X=toy_data$X,lambda=0.1)
 print(Evaluation$f) # here is the fitness of the whole population

 # evaluation of one of the permutation
 Perm <- Pop[1,]
 Evaluation <- evaluation(Pop=Perm,toy_data$X,lambda=0.1)

 # optimal matrix T associated to Perm:
 T <- matrix(Evaluation$Tpop,p,p)
}
\seealso{
\code{\link{GADAG}}, \code{\link{GADAG_Run}}, \code{\link{fitness}}.
}
\author{
\packageAuthor{GADAG}
}
