% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateToyData.R
\name{generateToyData}
\alias{generateToyData}
\title{Generate toy data for running GADAG}
\usage{
generateToyData(n, p, edgemin = 0, type = "star", seed = 42)
}
\arguments{
\item{n}{Number of samples in the design matrix.}

\item{p}{Number of nodes of the DAG.}

\item{edgemin}{Minimal value for the non-null edges of the DAG (between 0 and 1).}

\item{type}{Form of the DAG. It can be chosen between 7 alternatives: \code{"star"}, \code{"bistar"}, \code{"full"}, \code{"path"}, \code{"quadristar"}, \code{"sixstar"} (see details below).}

\item{seed}{Fix the seed.}
}
\value{
A list containing the design nxp matrix X (with samples in rows and variables in columns) and the adjacency matrix G associated to the DAG with p nodes.
}
\description{
This function generates toy data that can be used to run GADAG: the adjacency matrix of a DAG with p nodes and the design matrix with n observations of the distribution of the p nodes.
}
\details{
One of the following seven alternatives can be chosen for the DAG form:
\itemize{
\item{\code{"star"}}{ star-shaped DAG (all active edges start from node 1),}
\item{\code{"bistar"}}{ half of the edges start from node 1 and the other half from node 2,}
\item{\code{"full"}}{ full DAG (all the edges are active),}
\item{\code{"path"}}{ path-shaped DAG (all the nodes are connected by a single path),}
\item{\code{"quadristar"}}{ node 1 is connected to nodes 2 to 4, each being connected to 1/3 of the rest of the nodes,}
\item{\code{"sixstar"}}{ same as \code{"quadristar"}, with 6 nodes.}
}
}
\examples{
 #############################################################
 # Generating toy data
 #############################################################
 toy_data <- generateToyData(n=100, p=10)

 # toy_data is a list of two matrices corresponding to a "star"
 # DAG (node 1 activates all other nodes):
 # - toy_data$X is a 100x10 design matrix
 # - toy_data$G is the 10x10 adjacency matrix (ground trough)

 \dontrun{
 # generate another type of data: a DAG with 100 nodes in a path form
 toy_data <- generateToyData(n=100, p=100,type="path")
 }

 \dontrun{
 # set the minimal edge value to 1
 toy_data <- generateToyData(n=100, p=10, edgemin=1) # all edges are set to 1
 }
}
\seealso{
\code{\link{GADAG}}, \code{\link{GADAG_Run}}.
}
\author{
\packageAuthor{GADAG}.
}
