% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin.R
\name{bin}
\alias{bin}
\title{Binning Genotypes for Dimensional Reduction}
\usage{
bin(genotype = genotype, binvar = 0.15)
}
\arguments{
\item{genotype}{a matrix for genotypes in numeric format, coded as 1, 0 and -1, with individuals in rows and markers in cols.}

\item{binvar}{a hyper-parameter between 0 and 1, the closer to 0, the fewer bins yields.
Users can choose binvar based on the required number of bins, default is 0.15.}
}
\value{
A list with following information is returned:
    $bins_genotypes  binned genotypes
    $bins_range  start and stop of each bin
}
\description{
Binning the original genotypes into bins for dimensional reduction 
under the principle of linkage disequilibrium.
}
\examples{
\donttest{
## load example data from GAGBLUP package
data(genotype)
## binning genotypes
bins <- bin(genotype,0.2)
 }
}
