#' AIC for GARCHX model
#'
#' Calculates the Akaike Information Criterion for GARCHX model
#'
#' @param model GARCHX object
#'
#' @return AIC of GARCHX model
#' @export
#'
#' @examples set.seed(123)
#' @examples pi <- c(1, 0, 0, 4)
#' @examples n <- 2000
#' @examples d <- length(pi)
#' @examples valinit <- 100
#' @examples n2 <- n + d + 1
#' @examples omega <- 0.1
#' @examples alpha <- 0.2
#' @examples beta <- 0.3
#' @examples delta <- 2
#' @examples e<-rnorm(n2+valinit)
#' @examples Y<-e
#' @examples for (t in 2:n2)
#' @examples  Y[t]<- 0.2*Y[t-1]+e[t]
#' @examples x<-exp(Y)
#' @examples X <- matrix(0, nrow = (n+valinit), ncol = length(pi))
#' @examples for(j in 1:d)
#' @examples  X[, j] <- x[(d+2-j):(n+d+1-j+valinit)]
#' @examples data <- GARCHX::simulate(n, omega, alpha, beta, delta, X, pi, valinit = valinit)
#' @examples model <- GARCHX_select(eps = data$eps, X = data$X)
#' @examples AIC_value <- AIC(model)
AIC <- function(model){
  UseMethod("AIC")
} # End AIC
