% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmgceclassfunctions.R
\name{plot.lmgce}
\alias{plot.lmgce}
\title{Plot Diagnostics for a \code{\link{lmgce}} Object}
\usage{
\method{plot}{lmgce}(
  x,
  type = c("ggplot2", "plotly"),
  which = 1:7,
  ci.level = 0.95,
  ci.method = c("z", "percentile", "basic"),
  boot.B = ifelse(x$boot.B == 0, 100, x$boot.B),
  boot.method = x$boot.method,
  coef = NULL,
  OLS = TRUE,
  NormEnt = TRUE,
  caption = list(paste0("Estimates (", ci.method[1], " ", ci.level * 100, "\% CI)"),
    "Prediction Error vs supports", "Estimates vs supports",
    "Normalized Entropy vs supports", "Precision Error vs supports",
    "Prediction Error vs GCE reestimation", "Precision Error vs GCE reestimation"),
  ...
)
}
\arguments{
\item{x}{Fitted \code{\link{lmgce}} model object.}

\item{type}{One of \code{c("ggplot2", "plotly")}. "ggplot2" is used
by default.}

\item{which}{A subset of the numbers 1:7.}

\item{ci.level}{the confidence level (0,1) required to compute the confidence
interval.}

\item{ci.method}{the method used to compute the confidence interval. One of
c("z","percentile", "basic"). The default is \code{method = "z"}.}

\item{boot.B}{A single positive integer greater or equal to 10 for the number
of bootstrap replicates for the computation of the bootstrap confidence
interval(s), to be used when \code{method = c("percentile", "basic")} and
when \code{object} was created with \code{boot.B = 0}. The default is
\code{boot.B = 100} when the \code{object} has no previous sampling information
and \code{boot.B = object$boot.B} otherwise, which corresponds to
the \code{boot.B} given to \code{lmgce} when the \code{object} was created.}

\item{boot.method}{Method used for bootstrapping. One of
\code{c("residuals", "cases", "wild")} which corresponds to resampling on
residuals, on individual cases or on residuals multiplied by a N(0,1) variable,
respectively. The default is \code{boot.method = object$boot.method}.}

\item{coef}{A vector of true coefficients to be used when \code{which = c(5,7)}.}

\item{OLS}{Boolean value. if \code{TRUE}, the default, plots the OLS results.}

\item{NormEnt}{Boolean value. if \code{TRUE}, the default, plots the
normalized entropy.}

\item{caption}{Captions to appear above the plots;
\code{\link[base]{character}} vector or \code{\link[base]{list}}
of valid graphics annotations, see \code{\link[grDevices]{as.graphicsAnnot}},
of length 7, the j-th entry corresponding to which[j]. Can be set to "" or
\code{NA} to suppress all captions.}

\item{...}{additional arguments.}
}
\value{
A named list of \code{ggplot} or \code{plotly} objects, each
representing a separate plot.
}
\description{
Seven plots (selectable by \code{which}) are currently available to
evaluate a \code{\link{lmgce}} object: a plot of the Estimates and confidence
intervals; four plots of supports against Prediction Error, Estimates,
Normalized Entropy and Precision Error; two plots of GCE reestimation against
Prediction and Precision Errors. Note that plots regarding Precision Error are
only produced if the argument \code{coef} is not \code{NULL}.
}
\examples{
\donttest{
res_gce_package <-
  lmgce(y ~ .,
        data = dataGCE,
        boot.B = 50,
        seed = 230676)
}
plot(res_gce_package)

}
\seealso{
\code{\link{lmgce}}
}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
