% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmgceclassfunctions.R
\name{print.summary.lmgce}
\alias{print.summary.lmgce}
\title{Print Summary of \code{\link{lmgce}} Model Fits}
\usage{
\method{print}{summary.lmgce}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  symbolic.cor = x$symbolic.cor,
  signif.stars = getOption("show.signif.stars"),
  ...
)
}
\arguments{
\item{x}{an object of class \code{\link{summary.lmgce}}, usually, a result of
a call to \code{\link{summary.lmgce}}.}

\item{digits}{The number of significant digits to use when printing.}

\item{symbolic.cor}{Boolean value. if \code{TRUE}, print the correlations in
a symbolic form (see \code{\link[stats]{symnum}}) rather than as numbers.}

\item{signif.stars}{Boolean value. if \code{TRUE}, ‘significance stars’ are
printed for each coefficient.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The function \code{print.summary.lmgce} prints the information in a
\code{\link{summary.lmgce}} object.
}
\description{
\code{print.summary} method for class \code{\link{lmgce}}.
}
\examples{
\donttest{
res_gce_package <-
  lmgce(y ~ .,
        data = dataGCE,
        boot.B = 50,
        seed = 230676)
}

summary(res_gce_package)

summary(res_gce_package, ci.level = 0.90, ci.method = "basic")

}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
