% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appl_hotspots.r
\name{hotspots.poislpp}
\alias{hotspots.poislpp}
\title{Hot spots detection for Poisson point process
- parallel version}
\usage{
hotspots.poislpp(
  PP,
  formula,
  data,
  sigma = 250,
  nsim = 10000,
  ncores = 1L,
  ...
)
}
\arguments{
\item{PP}{The point pattern living in a network.}

\item{formula}{A formula for the intensity.}

\item{data}{Data from where the formula takes objects.
Must be acceptable by the function lppm of spatstat.linnet.}

\item{sigma}{To be passed to density.lpp.}

\item{nsim}{Number of simulations to be performed.}

\item{ncores}{Number of cores used for computations. Default to 1.
If NULL, all available cores are used.}

\item{...}{Additional parameters to be passed to \code{\link{fdr_envelope}}.}
}
\description{
See the hotspots vignette available by starting R, typing
\code{library("GET")} and \code{vignette("GET")}.
}
\references{
Mrkvička et al. (2023). Hotspot detection on a linear network in the presence of covariates: A case study on road crash data. DOI: 10.2139/ssrn.4627591
}
