% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_summary_plot.R
\name{plot.gfdmcv}
\alias{plot.gfdmcv}
\title{Plot simultaneous confidence intervals for contrasts}
\usage{
\method{plot}{gfdmcv}(x, ...)
}
\arguments{
\item{x}{an "gfdmcv" object.}

\item{...}{additional arguments not used.}
}
\value{
No return value, called for side effects.
}
\description{
Simultaneous confidence intervals for contrasts for CV and MCVs and their reciprocals are plotted.
}
\examples{
# Some of the examples may run some time. 
# For more examples, see the documentation of the GFDmcv() function.
data_set <- lapply(list(iris[iris$Species == "setosa", 1:3],
                        iris[iris$Species == "versicolor", 1:3],
                        iris[iris$Species == "virginica", 1:3]),
                   as.matrix)
# estimators and confidence intervals of MCVs and their reciprocals
lapply(data_set, e_mcv)
# contrast matrices
k <- length(data_set)
# Tukey's contrast matrix
h_mct <- contr_mat(k, type = "Tukey")
# centering matrix P_k
h_wald <- contr_mat(k, type = "center") 
\donttest{
# testing without parallel computing
res <- GFDmcv(data_set, h_mct, h_wald)
oldpar <- par(mar = c(4, 5, 2, 0.3))
plot(res)
par(oldpar)
}

}
