\name{infants}
\alias{infants}
\alias{NC.polys}
\docType{data}

\title{Infant statistic data from North Carolina}

\description{Individual-level infant mortality data on 20000 randomly selected births of female babies in the U.S. state of North Carolina, in 2008, together with polygons describing the county shapes.}

\usage{
data(infants)
data(NC.polys)

}


\format{\code{infants} is a 20000 row data frame with the following columns: 

\describe{
         
\item{county}{Number code identifying North Carolina county in which birth occurred, and matching \code{names(NC.polys)}. It can take 100 possible values.}
\item{age}{Age of mother.}
\item{wksgest}{Completed weeks of gestation.}
\item{marital}{Equal to 1 if married, and 0 otherwise.}
\item{grams}{Infant's birth weight.}
\item{lbw}{Equal to 1 if infant's birth weight < 2500 grams, and 0 otherwise.}
\item{ethnicity}{Four categories of ethnicity: White, Hispanic, Black, Other.}
\item{educ}{Education of mother: Primary, Secondary, Tertiary.}
\item{smoke}{Equal to 1 if smoker, and 0 otherwise.}
\item{firstbirth}{Equal to 1 if it was the mother's first birth, and 0 otherwise.}
\item{ptb}{Equal to 1 if completed weeks of gestation < 37.}



}

\code{NC.polys} contains the polygons defining the areas in the format described below.


} 

\details{The data frame \code{infants} relates to the counties whose boundaries are coded in \code{NC.polys}.
\code{NC.polys[[i]]} is a 2 column matrix, containing the vertices of the polygons defining the boundary of the ith 
county. \code{names(NC.polys)} matches \code{infants$county} (order unimportant).

}


\source{

The data were compiled by the North Carolina State Center for Health Statistics (https://schs.dph.ncdhhs.gov/).

}

