% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TS.Lasso.R
\name{TS.Lasso}
\alias{TS.Lasso}
\title{Two-Step Lasso for missing peaks imputation}
\usage{
TS.Lasso(input_data, alpha = 1, nfolds = 10, log.scale = TRUE)
}
\arguments{
\item{input_data}{Raw abundance matrix with missing value, with features in rows and samples in columns.}

\item{alpha}{Weights for L1 penalty in Elastic Net. The default and suggested value is alpha=1, which is for Lasso.}

\item{nfolds}{The number of folds used in parameter (lambda) tuning.}

\item{log.scale}{Whether the input_data needs log scale transform.The default is log.scale=T, assuming input_data is the
raw abundance matrix. If input_data is log abundance matrix, set log.scale=F.}
}
\value{
\item{imputed.final}{The imputed abundance matrix at the scale of input_data.}
}
\description{
TS.Lasso recovers the abundance of various types of missing peaks.
}
\examples{
data('tcga.bc')
# tcga.bc contains mass specturm abundance of 150 metabolites for 30 breast cancer
# tumor and normal tissue samples with missing values.

imputed=TS.Lasso(tcga.bc,log.scale=TRUE)
# Impute raw abundance matrix tcga.bc

}
