% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing.sim.R
\name{missing.sim}
\alias{missing.sim}
\title{Missing peaks generating procedure for simulation study}
\usage{
missing.sim(complete.data, total.missing, random, pct.full,
  seednum = 365)
}
\arguments{
\item{complete.data}{The full abundance matrix without missing value, with features in rows and samples in columns.}

\item{total.missing}{A scalar or vector of proportions. It is the total percentage of missing peaks throughout the full matrix.}

\item{random}{A scalar or vector of proportions. It is the percentage of random missing in all the missing peaks.}

\item{pct.full}{A scalar for the percentage of alighned features (metabolites or peptides) without missing peaks.}

\item{seednum}{The seed set for generating missing peaks index. Default seed is seednum=365.}
}
\value{
\item{simulated.data}{The list of all simulated scenarios}
   \item{Labels}{The description for each simulated scenario}
}
\description{
missing.sim generates various types of missing peaks based on specified missing proportion.
}
\examples{
data('tcga.bc.full')
# tcga.bc.full contains mass specturm abundance of 100 metabolites for 30 breast cancer 
# tumor and normal tissue samples without missing values.


simulated.data=missing.sim(tcga.bc.full,total.missing=c(0.2,0.4),random=c(0.3,0.5,0.7),pct.full=0.4)
# Generate missing (NA) values in full abundance matrix tcga.bc.full permuting all scenarios

}
