% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOCluster.R
\name{GOCluster}
\alias{GOCluster}
\title{Circular dendrogram.}
\usage{
GOCluster(data, process, metric, clust, clust.by, nlfc, lfc.col, lfc.min,
  lfc.max, lfc.space, lfc.width, term.col, term.space, term.width)
}
\arguments{
\item{data}{A data frame which should be the result of 
\code{\link{circle_dat}} in case the data contains only one logFC column. 
Otherwise \code{data} is a data frame whereas the first column contains the
genes, the second the term and the following columns the logFCs of the 
different contrasts.}

\item{process}{A character vector of selected processes (ID or term
description)}

\item{metric}{A character vector specifying the distance measure to be used 
(default='euclidean'), see \code{dist}}

\item{clust}{A character vector specifying the agglomeration method to be 
used (default='average'), see \code{hclust}}

\item{clust.by}{A character vector specifying if the clustering should be 
done for gene expression pattern or functional categories. By default the 
clustering is done based on the functional categories.}

\item{nlfc}{If TRUE \code{data} contains multiple logFC columns (default= 
FALSE)}

\item{lfc.col}{Character vector to define the color scale for the logFC of 
the form c(high, midpoint,low)}

\item{lfc.min}{Specifies the minimium value of the logFC scale (default = -3)}

\item{lfc.max}{Specifies the maximum value of the logFC scale (default = 3)}

\item{lfc.space}{The space between the leafs of the dendrogram and the ring 
for the logFC}

\item{lfc.width}{The width of the logFC ring}

\item{term.col}{A character vector specifying the colors of the term bands}

\item{term.space}{The space between the logFC ring and the term ring}

\item{term.width}{The width of the term ring}
}
\description{
GOCluster generates a circular dendrogram of the \code{data} 
  clustering using by default euclidean distance and average linkage.The 
  inner ring displays the color coded logFC while the outside one encodes the
  assigned terms to each gene.
}
\details{
The inner ring can be split into smaller rings to display multiply
  logFC values resulting from various comparisons.
}
\examples{
\dontrun{
#Load the included dataset
data(EC)

#Generating the circ object
circ<-circular_dat(EC$david, EC$genelist)

#Creating the cluster plot
GOCluster(circ, EC$process)

#Cluster the data according to gene expression and assigning a different color scale for the logFC
GOCluster(circ,EC$process,clust.by='logFC',lfc.col=c('darkgoldenrod1','black','cyan1'))
}
}

