% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPP.R
\name{GPP}
\alias{GPP}
\alias{GPP,ANY-method}
\title{Estimates a counterfactual with uncertainty using Gaussian process projection}
\usage{
GPP(
  df,
  controlVars,
  nUntreated,
  obvColName,
  obvName,
  outcomeName,
  starttime,
  timeColName,
  ncores = NULL,
  epsilon = 0.02,
  noise = 0.1,
  printMod = FALSE,
  shift = 0.05,
  iter = 25000,
  filepath = NULL,
  legendLoc = "topleft",
  xlabel = NULL,
  ylabel = NULL,
  actualdatacol = "black",
  preddatacol = "red",
  ...
)
}
\arguments{
\item{df}{The dataframe used for the model.}

\item{controlVars}{String of column names for control variables.}

\item{nUntreated}{The number of untreated units in the model.}

\item{obvColName}{The column name that includes the observation subject to the counterfactual.}

\item{obvName}{The name of the observation subject to the counterfactual.}

\item{outcomeName}{The outcome variable of interest.}

\item{starttime}{The start year of the counterfactual estimation.}

\item{timeColName}{The name of the column that includes the time variable.}

\item{ncores}{The number of cores to be used to run the model. See details.}

\item{epsilon}{The desired level of convergence.}

\item{noise}{The baseline level of noise to be added to the model to prevent overfit. Updates as the model runs.}

\item{printMod}{Boolean. Defaults FALSE. If TRUE, prints each model block to the console. See details.}

\item{shift}{The magnitude of adjustment for the noise level per iteration. Defaults to 0.05.}

\item{iter}{The number of iterations you would like to run. Defaults to 25,000. See details.}

\item{filepath}{Your preferred place to save the fit data. See Details.}

\item{legendLoc}{The preferred location of the legend in the final graph. Defaults to "topleft".}

\item{xlabel}{The label of the x-axis in the final graph. Defaults to input for 'timeColName'.}

\item{ylabel}{The preferred label of the y-axis in the final graph. Defaults to input for 'outcomeName'.}

\item{actualdatacol}{The preferred color for plotted line for actual data. Defaults to black.}

\item{preddatacol}{The preferred color for plotted line for predicted counterfactual data. Defaults to red.}

\item{...}{Further parameters passed to the plot function.}
}
\value{
A plot of the actual values and the estimated counterfactual values of the model, and the final model fit.
}
\description{
Returns a list of a plot object (after making the plot) of estimated counterfactual values after checking for model convergence and adjusting the noise level, and returns the fitted model.
}
\details{
We recommend using all cores on your machine to speed up model run time. If you are unsure about the number of cores in your machine, see \code{parallel::detectCores()}.

We recommend keeping printMod as FALSE, otherwise, the function will write the model to the console for every model run on the convergence.

For iterations, check that your model converged (we recommend all r-hats close to 1 and examining traceplots).

We recommend creating a new folder for the file path since the Stan fit creates a large number of files at runtime.
}
\examples{

\donttest{
data(GDPdata)
out = GPP(df = GDPdata, 
    controlVars = c('invest', 'school', 'ind'),
    nUntreated = length(unique(GDPdata$country))-1, 
    obvColName = 'country', obvName = 'West Germany', 
    outcomeName = 'gdp', starttime = 1989, 
    timeColName = 'year',
    ncores = 2)
}

}
\seealso{
\code{\link{plotGPPfit}} \code{\link{writeMod}} \code{\link{runMod}} \code{\link{autoConverge}}
}
\author{
Devin P. Brown \email{devinpbrown96@gmail.com} and David Carlson \email{carlson.david@wustl.edu}
}
