% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgreen_plots.R
\name{compare_calib}
\alias{compare_calib}
\title{Plot comparing observed vs modeled loads for two set of parameters}
\usage{
compare_calib(
  catch_data,
  annual_data,
  alpha_p1,
  alpha_l1,
  sd_coef1,
  alpha_p2,
  alpha_l2,
  sd_coef2,
  years,
  name_basin,
  setPlabels
)
}
\arguments{
\item{catch_data}{data frame. Definition of the topological sequence of
catchments.}

\item{annual_data}{data frame. Sources of nutrient for each year and
catchments.}

\item{alpha_p1}{numeric. The basin retention coefficient of the first set of
parameters.}

\item{alpha_l1}{numeric. The river retention coefficient of the first set of
parameters.}

\item{sd_coef1}{numeric. Fraction of domestic diffuse sources that reaches
the stream network of the first set of parameters.}

\item{alpha_p2}{numeric. The basin retention coefficient of the second set of
parameters.}

\item{alpha_l2}{numeric. The river retention coefficient of the second set of
parameters.}

\item{sd_coef2}{numeric. Fraction of domestic diffuse sources that reaches
the stream network of the second set of parameters.}

\item{years}{numeric. Years to be shown in the plot.}

\item{name_basin}{character. Name of the basin (title of the plot).}

\item{setPlabels}{character. Labels identifying each set of parameter.}
}
\value{
A scatter plot and a list with two data frames with model GREEN
applied to two model parameter sets
}
\description{
Returns a scatter plot comparing observed versus modeled loads
obtained with two model parameter sets
}
\examples{
\donttest{
# the data of the TN scenario
data(catch_data_TN)
data(annual_data_TN)

# the first set of parameters to assess the basin model
alpha_p <- 35.09
alpha_l <- 0.02
sd_coef <- 0.2

# the second set of parameters to assess the basin model
alpha_p2 <- 41.23
alpha_l2 <- 0.0015
sd_coef2 <- 0.6

# years in which the plot will we shown
years <- 1990:2018

nameBasin <- "Lay"

# generating the scatter plot comparing two set of parameters observed
# versus modeled loads by year
setPlabels <- c("bestNSE","bestR2")
compare_calib(catch_data_TN, annual_data_TN, alpha_p , alpha_l, sd_coef,
alpha_p2, alpha_l2, sd_coef2, years, nameBasin, setPlabels)
}

}
