% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alex.waterfall.plot.R
\name{alex.waterfall.plot}
\alias{alex.waterfall.plot}
\title{Generate Waterfall Plot of Lesion and Expression Data}
\usage{
alex.waterfall.plot(waterfall.prep, lsn.data, lsn.clrs = NULL, delta = 0.5)
}
\arguments{
\item{waterfall.prep}{Output from \code{alex.waterfall.prep}. A list containing three data tables: \code{"gene.lsn.exp"} with patient IDs, lesion types, and expression levels for the gene of interest; \code{"lsns"} with all lesions affecting the gene (GRIN-compatible format); and \code{"stats"} with the Kruskal Wallis test result (from \code{KW.hit.express}).}

\item{lsn.data}{Lesion data in GRIN-compatible format.}

\item{lsn.clrs}{Named vector of colors for lesion types. If not provided, default colors will be automatically assigned using \code{default.grin.colors()}.}

\item{delta}{Spacing argument for the waterfall plot (default is 0.5).}
}
\value{
A side-by-side graphical representation of lesion status and gene expression for each patient, grouped by lesion type.
}
\description{
Creates a waterfall plot displaying gene expression levels grouped by lesion status for a selected gene.
}
\details{
This function generates a waterfall-style plot that visualizes gene expression across patients, grouped by lesion category. Patients are grouped by lesion type (sorted alphabetically), and within each group, expression levels are ordered from lowest to highest. The median expression level appears at the center of each group, allowing intuitive comparison between lesion categories.
}
\examples{
data(expr_data)
data(lesion_data)
data(hg38_gene_annotation)

# Prepare expression and lesion data
alex.data <- alex.prep.lsn.expr(expr_data, lesion_data,
                                hg38_gene_annotation, min.expr = 1, min.pts.lsn = 5)

# Run Kruskal Wallis test
alex.kw.results <- KW.hit.express(alex.data, hg38_gene_annotation, min.grp.size = 5)

# Prepare data for the WT1 gene
WT1.waterfall.prep <- alex.waterfall.prep(alex.data, alex.kw.results, "WT1", lesion_data)

# Generate waterfall plot for WT1
alex.waterfall.plot(WT1.waterfall.prep, lesion_data)
}
\references{
Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link{alex.prep.lsn.expr}}, \code{\link{KW.hit.express}}, \code{\link{alex.waterfall.prep}}
}
\author{
Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org}, Stanley Pounds \email{stanley.pounds@stjude.org}
}
