% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alex.waterfall.prep.R
\name{alex.waterfall.prep}
\alias{alex.waterfall.prep}
\title{Prepare Lesion and Expression Data for Waterfall Plots}
\usage{
alex.waterfall.prep(alex.data, alex.kw.results, gene, lsn.data)
}
\arguments{
\item{alex.data}{Output from \code{alex.prep.lsn.expr}. A list of three data tables: \code{"row.mtch"} (gene matching info), \code{"alex.expr"} (expression matrix), and \code{"alex.lsn"} (lesion matrix). Rows are ordered by Ensembl gene IDs, and columns are ordered by patient IDs.}

\item{alex.kw.results}{Kruskal Wallis test results for gene expression by lesion group, as returned by \code{KW.hit.express}.}

\item{gene}{Gene of interest, specified by either its gene symbol or Ensembl ID.}

\item{lsn.data}{Lesion data in GRIN-compatible format. A data frame with five required columns: \code{"ID"} (patient ID), \code{"chrom"} (chromosome), \code{"loc.start"} (lesion start), \code{"loc.end"} (lesion end), and \code{"lsn.type"} (lesion type; e.g., gain, loss, mutation, fusion, etc...).}
}
\value{
A list with the following components:
\item{gene.lsn.exp}{A data table with three columns: \code{"ID"} (patient ID), \code{"<gene_name>_lsn"} (lesion status: e.g., none, gain, mutation, multiple), and \code{"<gene_name>_expr"} (expression level of the gene in that patient).}
\item{lsns}{A data table of all lesions affecting the gene of interest, extracted from the input lesion data (GRIN-compatible format).}
\item{stats}{A one-row data frame containing the Kruskal Wallis test result for the gene, from \code{KW.hit.express}.}
\item{gene.ID}{The gene name (symbol or Ensembl ID) provided as input.}
}
\description{
Prepares matched lesion and expression data for a selected gene to be used with the \code{alex.waterfall.plot} function.
}
\details{
This function extracts and combines lesion and expression data for a specified gene across patients. It returns a data table showing each patient's lesion status and expression level for the gene. It also extracts the corresponding Kruskal Wallis test result and all lesions that affect the gene from the lesion data.
}
\examples{
data(expr_data)
data(lesion_data)
data(hg38_gene_annotation)

# Prepare matched expression and lesion data
alex.data <- alex.prep.lsn.expr(expr_data, lesion_data,
                                hg38_gene_annotation, min.expr = 1, min.pts.lsn = 5)

# Run Kruskal Wallis test
alex.kw.results <- KW.hit.express(alex.data, hg38_gene_annotation, min.grp.size = 5)

# Prepare lesion and expression data for waterfall plot of WT1
WT1.waterfall.prep <- alex.waterfall.prep(alex.data, alex.kw.results, "WT1", lesion_data)
}
\references{
Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link{alex.prep.lsn.expr}}, \code{\link{KW.hit.express}}
}
\author{
Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org}, Stanley Pounds \email{stanley.pounds@stjude.org}
}
