% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grin.lsn.boundaries.R
\name{grin.lsn.boundaries}
\alias{grin.lsn.boundaries}
\title{GRIN Evaluation of Lesion Boundaries}
\usage{
grin.lsn.boundaries(lsn.data, chrom.size)
}
\arguments{
\item{lsn.data}{A lesion data table containing only gain or deletion events. If gains are subdivided (e.g., into gains and amplifications based on log2Ratio values), both subtypes can be included. The same applies for deletions (e.g., homozygous and heterozygous).}

\item{chrom.size}{A chromosome size table with two required columns: \code{"chrom"} (chromosome identifier) and \code{"size"} (chromosome size in base pairs).}
}
\value{
A \code{data.frame} with five columns:
\item{gene}{Boundary identifier, based on unique start and end positions.}
\item{chrom}{Chromosome on which the boundary resides.}
\item{loc.start}{Start position of the boundary.}
\item{loc.end}{End position of the boundary.}
\item{diff}{Length of the boundary in base pairs.}
}
\description{
This function evaluates copy number variations (CNVs), specifically gains and deletions, using unique lesion start and end positions to define genomic boundaries. The analysis is lesion-type specific and spans the entire genome.
}
\details{
The function identifies unique CNV boundaries by evaluating the start and end positions of lesions on each chromosome. Large lesions may be split into smaller boundaries based on overlapping smaller lesions in other samples. This boundary-based approach ensures comprehensive genome-wide coverage, including intergenic regions and areas without annotated features.

The first boundary on each chromosome spans from the start of the chromosome to the start of the first lesion affecting any of the included patient samples. Similarly, the last boundary extends from the end of the last lesion to the end of the chromosome.

This method is particularly useful when analyzing CNV data at a finer resolution than gene-level annotation allows.
}
\examples{
data(lesion_data)
data(hg38_chrom_size)

# This analysis is lesion-type specific. For example, extract gains:
gain <- lesion_data[lesion_data$lsn.type == "gain", ]

# Generate lesion boundaries for gains:
lsn.bound.gain <- grin.lsn.boundaries(gain, hg38_chrom_size)

# Run GRIN using lesion boundaries as markers instead of gene annotations:
GRIN.results.gain.bound <- grin.stats(gain, lsn.bound.gain, hg38_chrom_size)

# The same analysis can be applied to deletions, mutations, or structural rearrangements.
}
\seealso{
\code{\link{grin.stats}}
}
\author{
Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}
}
