% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SOBOL.R
\name{SOBOL}
\alias{SOBOL}
\title{SOBOL indices}
\usage{
SOBOL(data_var, CM_mean, CM_var, pp_names)
}
\arguments{
\item{data_var}{a vector containing the variance of the model output for each
modelling time step.}

\item{CM_mean}{An array containing the conditional mean of each parameter of
the model. This array has dimensions of steps x t x pp, where steps is the
number of divisions of the parametric range, t is the number of temporary steps
and pp the number of parameters of the model.}

\item{CM_var}{An array containing the conditional variance of each parameter of
the model. This array has dimensions of steps x t x pp, where steps is the
number of divisions of the parametric range, t is the number of temporary steps
and pp the number of parameters of the model.}

\item{pp_names}{a strings vector with the names of the parameters of the model.}
}
\value{
a list containing two matrices. The first contains the first order sobol, the
second sobol_total.
}
\description{
This function calculates the first order and total  SOBOL indices.
}
\examples{
data("data_Bstat", "CM", "pp_names")
SOBOL_indices <- SOBOL(data_Bstat[,3], CM$CM_mean, CM$CM_var , pp_names)

}
\references{
Sobol, I. M. (2001). Global sensitivity indices for nonlinear mathematical models
and their Monte Carlo estimates. Mathematics and Computers in Simulation, 55(1–3),
271–280. https://doi.org/10.1016/S0378-4754(00)00270-6
}
\author{
Camila Garcia-Echeverri <cagarciae@unal.edu.co> \cr
Maria Cristina Areas-Bautista <mcarenasb@unal.edu.co> \cr


Hydrodynamics of the natural media research group - HYDS
National University of Colombia -  Bogota
}
