% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{PlotPredictions}
\alias{PlotPredictions}
\title{Plot true versus predicted output.}
\usage{
PlotPredictions(
  y_pred,
  y,
  y_name = "y",
  y_units = "",
  title = c("Predict", "CrossValidate"),
  pch = 1
)
}
\arguments{
\item{y_pred}{A data frame of predicted output values
made by \code{Predict} or \code{CrossValidate}.}

\item{y}{A vector of length equal to the number of rows in \code{y_pred}
containing the true output values.}

\item{y_name}{An optional character string containing the output variable name
(for labels).}

\item{y_units}{An optional character string constaining the units
of the output variable (for labels).}

\item{title}{A character string for the name of the function generating
the predictions (for an appropriate title):
"Predict" from \code{\link{Predict}} or
"CrossValidate" from \code{\link{CrossValidate}};
"" for no title.}

\item{pch}{Plotting symbol for \code{plot}; default is open circle.}
}
\value{
No return value, generates plots.
}
\description{
Plot true versus predicted output (response)
made by \code{Predict} or \code{CrossValidate}.
}
\examples{
\dontshow{
x <- borehole$x
y <- borehole$y
theta <- c(
  5.767699e+01, 0.000000e+00, 0.000000e+00, 1.433571e-06,
  0.000000e+00, 2.366557e-06, 1.695619e-07, 2.454376e-09
)
alpha <- c(
  1.110223e-16, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 2.494862e-03, 0.000000e+00
)
cor_par <- data.frame(Theta = theta, Alpha = alpha)
rownames(cor_par) <- colnames(borehole$x)
sp_var <- 38783.7
borehole_fit <- GaSPModel(
  x = borehole$x, y = borehole$y,
  reg_model = ~1, cor_family = "PowerExponential",
  cor_par = cor_par, random_error = FALSE,
  sp_var = sp_var
)
borehole_pred <- Predict(
  GaSP_model = borehole_fit,
  x_pred = borehole$x_pred,
  generate_coefficients = TRUE
)
borehole_cv <- CrossValidate(borehole_fit)
}
PlotPredictions(borehole_cv, y, title = "CrossValidate")

PlotPredictions(borehole_pred$y_pred, borehole$y_true, title = "Predict")
}
