% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimHMMGen.R
\name{SimHMMGen}
\alias{SimHMMGen}
\title{Simulation of univariate hidden Markov model}
\usage{
SimHMMGen(theta, size = 0, Q, ZI = 0, family, n)
}
\arguments{
\item{theta}{parameters; (r x p)}

\item{size}{additional parameter for some discrete distributions; run the command distributions() for help}

\item{Q}{transition probability matrix for regimes; (r x r)}

\item{ZI}{1 if zero-inflated, 0 otherwise (default)}

\item{family}{distribution name; run the function distributions() for help}

\item{n}{number of simulated observations}
}
\value{
\item{SimData}{Simulated data}

\item{MC}{Simulated Markov chain}
}
\description{
This function simulates observation from a univariate hidden Markov model
}
\examples{
\donttest{
family = "gaussian"
Q = matrix(c(0.8, 0.3, 0.2, 0.7), 2, 2) ;
theta = matrix(c(0, 1.7, 0, 10),2,2) ;
y = SimHMMGen(theta, Q=Q, ZI=1,family=family, n=50)$SimData
}
}
