#'@title Change-point statistics for GOU
#'
#'@description Function to compute Sigma covariance matrix and kappas of change-point statistics
#'
#'@param theta       list of parameters before change-point: cos coefficients (>=1), sine coefficients (>=0, and alpha
#'@param theta_star  list of parameters after  change-point: cos coefficients (>=1), sine coefficients (>=0, and alpha
#'@param sigma       volatility parameter of the GOU process
#'@return \item{out}{List containing Sigma and kappas for Q and G statistics}
#'
#'@examples
#' theta=list(cos=c(1,2),alpha=1)
#' theta_star=list(cos=c(2,4),alpha=2)
#' sigma=3
#' out = kappa(theta,theta_star, sigma)
#'@export



kappa=function(theta,theta_star,sigma)
{

  p1= length(theta$cos)


  kk = c(1:p1)
  alpha = theta$alpha

  c = alpha^2+4*pi^2*(kk-1)^2
  a = alpha/c
  mu = theta$cos

  p=p1+1

  omega = 0.5*sigma^2/alpha + sum(mu^2/c)
  L = -matrix(a*mu,nrow=1)
  Lt  = t(L)

  S=diag(p)
  S[p,1:p1] = L
  S[1:p1,p]= Lt
  S[p,p]=omega


  mu=c(mu,theta$sin)


  param=c(mu,alpha)
  param=matrix(param,ncol=1)



if(is.list(theta_star[[1]]))
{
  m=length(theta_star)}else
{
  m=1
 theta_star[[1]]=theta_star
}


  Q = rep(0,m)
  G = rep(0,m)

for(j in 1:m)
{

  alpha_star=theta_star[[j]]$alpha

  mu_star=c(theta_star[[j]]$cos,theta_star[[j]]$sin)
  param_star=matrix(c(mu_star,alpha_star),ncol=1)


  Q[j]=alpha*(mu_star[1]/alpha_star-mu[1]/alpha)
   dd=param_star-param
   x = S%*%dd
   G[[j]] = sqrt( sum(x^2)  )
}
 kappa=list(Q=Q,G=G)
  out=list(kappa=kappa,Sigma=S)
  out
}

