% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_age.R
\name{simulate_age}
\alias{simulate_age}
\title{Simulate ages}
\usage{
simulate_age(x, n = 1000)
}
\arguments{
\item{x}{data frame or list of data frames containing population data for age
groups. Each data frame must contain columns "AGEGRP" and "TOT_POP".}

\item{n}{simulated sample size.}
}
\value{
List of arrays containing simulated ages.
}
\description{
Simulate ages
}
\details{
Each data frame must contain 19 rows. The first row represents the total
population of all age groups while the next 18 rows represent age groups
from 0 to 89 in increments of 5 years.
}
\examples{
# Single data frame
x <- data.frame(AGEGRP = 0:18, TOT_POP = 0)
# populate only age range 40-44, set population total of all ages
x$TOT_POP[c(1, 10)] <- 100
simulate_age(x, 5)

# List of 2 data frames
y <- data.frame(AGEGRP = 0:18, TOT_POP = 0)
# populate age ranges 5-9 and 50-54
y$TOT_POP[c(3, 12)] <- 10
# set population total for all age groups
y$TOT_POP[1] <- sum(y$TOT_POP)
simulate_age(list(x = x, y = y), 15)

}
