% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_visualization.R
\name{plot_topic_prevalence}
\alias{plot_topic_prevalence}
\title{Visualize topic prevalence}
\usage{
plot_topic_prevalence(model_output)
}
\arguments{
\item{model_output}{The output from model_topics function}
}
\value{
A ggplot object representing the bar plot of topic prevalence.
}
\description{
This function creates a bar plot of the overall prevalence of each topic.
}
\examples{
\donttest{
# Create a temporary file with sample book IDs
temp_file <- tempfile(fileext = ".txt")
writeLines(c("1420", "2767052", "10210"), temp_file)

# Scrape reviews
reviews <- scrape_reviews(temp_file, num_reviews = 10, use_parallel = FALSE)

# Model topics
topic_results <- model_topics(reviews, num_topics = 2, num_terms = 5, english_only = TRUE)

# Visualize topic distribution
plot_topic_prevalence(topic_results)

# Clean up: remove the temporary file
file.remove(temp_file)
}
}
