% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_har.R
\name{write_har}
\alias{write_har}
\title{Write an R list to GEMPACK HAR}
\usage{
write_har(data, filename, maxSize = 10000)
}
\arguments{
\item{data}{A list}

\item{filename}{Path to the file to be created}

\item{maxSize}{Maximum size of data chunk in real array, default of 10,000}
}
\value{
No return value, called for side effects
}
\description{
This function writes a HAR file based on a list. If a list element contains attribute "description," then it is used to define the long header name

Some warnings: (1) you cannot have NA's in a HAR file, (2) empty strings are not allowed, (3) some programs (e.g., GEMPACK models) read chunks of data no longer than 1e4 bytes (set maxSize = 1e4), (4) all dimensions in arrays must have names (see example)
}
\examples{
myList = list(TEST = c('Test'))
attr(myList$TEST,'description') = "This is the long header name"
write_har(myList,'harfile.har')
file.remove('harfile.har')
}
