% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_exprs.R
\name{plot_exprs}
\alias{plot_exprs}
\title{Diagnostic plots showing individual marker distribution before and after mapping by HDStIM}
\usage{
plot_exprs(mapped_data, path = NULL, verbose = FALSE)
}
\arguments{
\item{mapped_data}{List output of the \code{\link{HDStIM}} function.}

\item{path}{Path to the folder to save figures generated by this function.}

\item{verbose}{Logical. To make function more verbose. Default is FALSE.}
}
\value{
A list of ggplot objects. If the path is not NULL, PNG files of the plots are saved in the specified folder.
}
\description{
Diagnostic plots showing individual marker distribution before and after mapping by HDStIM
}
\examples{
mapped_data <- HDStIM(chi11$expr_data, chi11$state_markers,
                  chi11$cluster_col, chi11$stim_label,
                  chi11$unstim_label, seed_val = 123, umap = FALSE, umap_cells = NULL,
                  verbose = FALSE)

pe <- plot_exprs(mapped_data, path = NULL, verbose = FALSE)
}
