% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmmvbClust.R
\name{hmmvbClust}
\alias{hmmvbClust}
\title{Cluster data with HMM-VB}
\usage{
hmmvbClust(
  data,
  model = NULL,
  control = clustControl(),
  rfsClust = NULL,
  nthread = 1,
  bicObj = NULL
)
}
\arguments{
\item{data}{A numeric vector, matrix, or data frame of observations.
Categorical values are not allowed. If a matrix or data frame, rows 
correspond to observations and columns correspond to variables.}

\item{model}{An object of class 'HMMVB' that contains trained HMM-VB obtained 
by the call to function \code{hmmvbTrain}.}

\item{control}{A list of control parameters for clustering. The defaults are set by 
the call \code{clustControl()}.}

\item{rfsClust}{A list of parameters for the reference cluster that can be used
for alignment. See \code{HMMVBclust}
for details.}

\item{nthread}{An integer specifying the number of threads used in clustering.}

\item{bicObj}{An object of class 'HMMVBBIC' which stores results of model selection. 
If provided, argument \code{model} is ignored.}
}
\value{
An object of class 'HMMVBclust'.
}
\description{
This function clusters dataset with HMM-VB. First, for each data point it finds an optimal state sequence
using Viterbi algorithm. Next, it uses Modal Baum-Welch algorithm (MBW) to find the modes
of distinct Viterbi state sequences. Data points associated the same modes form clusters. 
If different data sets are clustered using the same HMM-VB, clustering results of one data set
can be supplied as a reference during clustering of another data set to produce aligned clusters.
}
\examples{
# cluster using trained HMM-VB
Vb <- vb(1, dim=4, numst=2)
set.seed(12345)
hmmvb <- hmmvbTrain(iris[,1:4], VbStructure=Vb)
clust <- hmmvbClust(iris[,1:4], model=hmmvb)
show(clust)
pairs(iris[,1:4], col=getClsid(clust))

\donttest{
# cluster using HMMVBBIC object obtained in model selection
Vb <- vb(1, dim=4, numst=1)
set.seed(12345)
modelBIC <- hmmvbBIC(iris[,1:4], VbStructure=Vb)
clust <- hmmvbClust(iris[,1:4], bicObj=modelBIC)
show(clust)
pairs(iris[,1:4], col=getClsid(clust))}
}
\seealso{
\code{\link{HMMVB-class}}, \code{\link{HMMVBclust-class}}, \code{\link{hmmvbTrain}}
}
