% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainControl.R
\name{trainControl}
\alias{trainControl}
\title{Parameters for HMM-VB training.}
\usage{
trainControl(
  ninit0 = 1,
  ninit1 = 0,
  ninit2 = 0,
  epsilon = 1e-04,
  diagCov = FALSE
)
}
\arguments{
\item{ninit0}{The number of initializations for default scheme 0, under
which the k-means clustering for entire dataset is used to initialize the model.}

\item{ninit1}{The number of initializations for default scheme 1, under
which the k-means clustering for a subset of data is used to initialize the model.}

\item{ninit2}{The number of initializations for default scheme 2, under
which a random subset of data is used as cluster centroids to initialize the model.}

\item{epsilon}{Stopping criteria for Baum-Welch algorithm. Should be a small number in 
range (0,1).}

\item{diagCov}{A logical value indicating whether or not variable block covariance matrices
will be diagonal.}
}
\value{
The named list with parameters.
}
\description{
This function creates a list with parameters for estimating an HMM-VB,
which is used as an argument for \code{hmmvbTrain}.
}
\examples{
# setting up multiple initialization schemes
Vb <- vb(1, dim=4, numst=2)
set.seed(12345)
hmmvb <- hmmvbTrain(iris[,1:4], VbStructure=Vb, 
          trControl=trainControl(ninit0=2, ninit1=2, ninit2=2))
show(hmmvb)

# forcing diagonal covariance matrices
Vb <- vb(1, dim=4, numst=2)
set.seed(12345)
hmmvb <- hmmvbTrain(iris[,1:4], VbStructure=Vb, 
          trControl=trainControl(diagCov=TRUE))
show(hmmvb)
}
\seealso{
\code{\link{hmmvbTrain}}
}
