% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supporting_function.R
\name{summarize_feature_name}
\alias{summarize_feature_name}
\title{Summarize the features (e.g. genes) that contribute to the test result, i.e. those features consistently show up in Lasso vectors.}
\usage{
summarize_feature_name(testing_result, method = "majority voting")
}
\arguments{
\item{testing_result}{The output/test result list from anchored_lasso_testing().}

\item{method}{How to combine the feature list across different splits. Default is 'majority voting'---features that show up more than 50\% of the splits are considered active/useful. It can be 'union'---all the features pooled together; or 'intersection'---only include features showing up in all splits.}
}
\value{
A list of names of features (your very original input data need to have column names!) that contribute to the test result. An empty list means there is barely any difference between the two groups.

Feature names that consistently showing up in the discriminant vectors.
}
\description{
Summarize the features (e.g. genes) that contribute to the test result, i.e. those features consistently show up in Lasso vectors.
}
